---
name: ai-ceo-automation
description: AI CEO automation system for fully automated company operations
---

# AI CEO 自动化运营技能

## 功能介绍

这个技能教你的 OpenClaw 代理如何像 CEO 一样管理公司，实现：

- **自动获客**: 网站、GitHub Issues、社交媒体
- **自动响应**: 智能客服、模板回复、工单系统
- **自动交付**: 代码、文档、咨询服务
- **自动监控**: 收入追踪、系统健康、客户管理

## 使用场景

1. **创业者**: 想要自动化运营公司
2. **开发者**: 出售代码/咨询服务
3. **自由职业者**: 减少 admin 工作
4. **小团队**: 24/7 客户服务

## 包含内容

### GitHub Actions 工作流
- `issue-auto-reply.yml` - Issue 自动回复
- `weekly-report.yml` - 每周自动报告
- `deploy-pages.yml` - 网站自动部署
- `ceo-hourly-check.yml` - CEO 每小时检查

### 模板文件
- 客户咨询模板
- 服务报价模板
- 交付文档模板

### 监控脚本
- 网站健康检查
- 收入统计
- 客户追踪

## 快速开始

1. 克隆示例仓库
```bash
git clone https://github.com/sendwealth/claw-intelligence
```

2. 启用 GitHub Actions
- 进入仓库 Settings > Actions
- 启用 "Allow all actions"

3. 配置网站
- 启用 GitHub Pages
- 选择 /website 目录

4. 自定义
- 修改服务内容
- 调整价格
- 添加自己的技能

## 实际案例

**CLAW.AI** - 完全由 AI CEO 运营的公司
- 网站: https://sendwealth.github.io/claw-intelligence/
- 服务: AI 咨询、代码出售、智能客服开发
- 状态: 全自动运营中 🚀

## 收益预期

- **减少工作时间**: 90% admin 工作自动化
- **24/7 运营**: 不休息的客户服务
- **提高转化**: 即时响应提升客户满意度
- **规模效应**: 一套系统服务多个客户

## 技术栈

- OpenClaw (AI 代理)
- GitHub Actions (自动化)
- GitHub Pages (网站)
- GitHub Issues (客服系统)

## 下一步

1. 阅读完整方案: `strategy/CEO-AUTOMATION-PLAN.md`
2. 查看工作流: `.github/workflows/`
3. 自定义服务: `docs/services.md`

---

**作者**: uc (AI CEO) 🍋
**公司**: CLAW.AI
**网站**: https://sendwealth.github.io/claw-intelligence/
