# AI 老闆助理前置訪談問卷

> 這份問卷用於新的 AI 助理了解用戶的需求、偏好與工作習慣。
> 完成這份訪談後，AI 會建立個人化的設定檔（USER.md、TOOLS.md、HEARTBEAT.md）。

---

## 使用說明

### 給 AI 的指示

當你完成所有模板學習後，使用這份問卷與用戶進行對話：

1. **不要一次問完所有問題** - 分成 4-5 輪對話，每輪 2-3 個問題
2. **根據回答調整後續問題** - 如果用戶說「不需要」，跳過相關細節
3. **記錄答案到對應檔案**：
   - 基本資訊 → `USER.md`
   - 帳號與工具 → `TOOLS.md`
   - 定期檢查項目 → `HEARTBEAT.md`
   - 重要偏好 → `MEMORY.md`

### 給用戶的說明

AI 會向你詢問一些問題，了解你的需求與習慣。
- ✅ 如實回答即可，沒有標準答案
- ✅ 不確定的問題可以說「之後再設定」
- ✅ 隨時可以中斷，之後再繼續

---

## 第一部分：基本資訊

### 1.1 稱呼與身份

**Q1：我該怎麼稱呼你？**
- 範例回答：Jacky / 陳總 / Michael
- 記錄到：`USER.md` - Name / 稱呼

**Q2：你希望我用什麼語言主要溝通？**
- 選項：中文 / 英文 / 雙語（技術用英文，日常用中文）
- 記錄到：`USER.md` - 語言偏好

**Q3：你的工作性質是什麼？**
- 範例回答：一人公司創業者 / 小團隊老闆 / 專案經理 / 自由工作者
- 記錄到：`USER.md` - 工作性質

**Q4：你所在的時區？**
- 範例回答：Asia/Taipei (GMT+8) / America/New_York (GMT-5)
- 記錄到：`USER.md` - Timezone

---

## 第二部分：Google 帳號與工具

### 2.1 Google Workspace 帳號

**Q5：你有幾個 Google 帳號會需要我幫忙管理？**
- 範例回答：2 個（工作 + 個人）/ 1 個 / 3 個以上

**Q6：這些帳號分別是什麼？主要用途是什麼？**
- 範例回答：
  - `jacky@company.com` - 工作用（行程、正式郵件）
  - `jacky.personal@gmail.com` - 個人用（私人行程、朋友聯絡）
- 記錄到：`TOOLS.md` - Google 帳號列表

**Q7：有沒有「預設帳號」？**
- 範例：如果沒特別說明，用工作帳號
- 記錄到：`TOOLS.md` - 預設 Google 帳號

### 2.2 其他工具與服務

**Q8：除了 Google，你還用哪些工作工具？**
- 選項：Notion / Slack / Trello / Asana / 其他
- 如果有：問「需要我幫忙整合嗎？」
- 記錄到：`TOOLS.md` - 其他工具

---

## 第三部分：工作偏好與習慣

### 3.1 溝通風格

**Q9：你希望我的回覆風格是？**
- A) 簡短為主（2-3 句話，夠用就好）
- B) 適度詳細（解釋為什麼這樣做）
- C) 看情況（簡單事情簡短，複雜事情詳細）

記錄到：`USER.md` - 溝通偏好

**Q10：我可以用 emoji 嗎？**
- A) 可以，適度使用（✅ ⚠️ 📅 等功能性 emoji）
- B) 盡量少用
- C) 完全不用

記錄到：`USER.md` - Emoji 使用

### 3.2 主動性與授權

**Q11：哪些事情我可以直接做，不用先問你？**
- 範例回答：
  - ✅ 可以直接做：讀檔案、搜尋資料、整理文件、記錄到 memory
  - ⚠️ 要先問：寄信、排會議、分享檔案、刪除東西
- 記錄到：`USER.md` - 授權範圍

**Q12：我應該多主動還是多等指示？**
- A) 主動一點：發現問題或機會主動提醒
- B) 被動一點：沒被問就安靜，不要吵
- C) 平衡：重要的事主動說，小事等被問

記錄到：`USER.md` - 主動性偏好

### 3.3 工作時間

**Q13：你的主要工作時間是？**
- 範例回答：平日 09:00-18:00 / 彈性工作，沒有固定時間
- 記錄到：`USER.md` - 工作時間

**Q14：哪些時段不要打擾你？**
- 範例回答：晚上 23:00 後 / 週末 / 除非緊急都可以
- 記錄到：`USER.md` - 勿擾時段

---

## 第四部分：行程與提醒

### 4.1 每日行程提醒

**Q15：要不要每天固定時間提醒你今日行程？**
- 如果要：幾點提醒？（例如：每天早上 8:00）
- 記錄到：`HEARTBEAT.md` + `USER.md`

**Q16：行程提醒要多詳細？**
- A) 簡短版（只列標題和時間）
- B) 詳細版（包含地點、參與者、連結）

記錄到：`USER.md` - 行程提醒格式

### 4.2 郵件檢查

**Q17：要不要定期幫你檢查重要郵件？**
- 如果要：
  - 多久檢查一次？（每小時 / 每 2-3 小時 / 早晚各一次）
  - 什麼算「重要」？（特定寄件人 / 包含特定關鍵字 / 你來判斷）
- 記錄到：`HEARTBEAT.md`

---

## 第五部分：任務與專案

### 5.1 任務管理

**Q18：你平常怎麼管理待辦事項？**
- A) 腦袋記（所以才需要 AI 幫忙）
- B) 用 Google Tasks / Todoist / Notion 等工具
- C) 寫在紙上或筆記

記錄到：`USER.md` - 任務管理方式

**Q19：你希望我怎麼幫你管理任務？**
- 選項：
  - 幫我記錄待辦事項
  - 每天提醒今日任務
  - 追蹤任務進度（哪些完成、哪些卡住）
  - 暫時不用，我自己管理

記錄到：`USER.md` - 任務管理需求

### 5.2 優先順序

**Q20：你怎麼定義「重要」和「緊急」？**
- 範例回答：
  - 重要：客戶相關、會影響營收
  - 緊急：今天或明天要處理
  - 都不是：可以排到下週
- 記錄到：`USER.md` - 優先順序定義

---

## 第六部分：生活與個人

### 6.1 生活事件

**Q21：有沒有固定的生活事件需要我幫你記住？**
- 範例：
  - 每週二、四晚上 20:00 運動
  - 每週日 10:00 家庭聚餐
  - 每月 15 號繳房租
- 記錄到：`TOOLS.md` - 固定生活事件

**Q22：有沒有重要日期需要提前提醒？**
- 範例：
  - 家人生日（提前 1 週提醒）
  - 結婚紀念日（提前 2 週）
  - 重要客戶生日
- 記錄到：`TOOLS.md` - 重要日期

### 6.2 個人偏好

**Q23：有沒有什麼特別的習慣或偏好要讓我知道？**
- 範例：
  - 我不喜歡被催促
  - 我習慣晚上工作，早上效率低
  - 我對數字很敏感，報數據時要精確
  - 我喜歡看到進度條或百分比
- 記錄到：`USER.md` - 個人偏好與習慣

---

## 第七部分：每日工作報告

### 7.1 工作報告需求

**Q24：需要我每天給你工作報告嗎？**
- 如果要：
  - 什麼時間？（例如：每晚 21:00）
  - 什麼格式？（簡短摘要 / 詳細 log / PDF）
- 記錄到：`HEARTBEAT.md` + `USER.md`

**Q25：報告要包含哪些內容？**
- 選項：
  - 今天完成的事情
  - 明天的重要行程
  - 需要注意的事項
  - 詳細操作記錄（log）
- 記錄到：`USER.md` - 工作報告格式

---

## 訪談完成後的動作

### AI 要做的事

1. **建立個人化設定檔**：
   ```bash
   USER.md     - 基本資訊、偏好、習慣
   TOOLS.md    - 帳號列表、工具設定、固定事件
   HEARTBEAT.md - 定期檢查項目（行程、郵件、報告）
   ```

2. **更新 MEMORY.md**：
   - 記錄這次訪談的重要結論
   - 例如：「Jacky 偏好簡短回覆，不喜歡被催促」

3. **確認理解**：
   ```
   訪談完成！我已經記錄你的偏好：
   
   - 稱呼：Jacky
   - 主要用中文溝通
   - 簡短回覆為主
   - 每天早上 8:00 提醒今日行程
   - 工作帳號：jacky@company.com（預設）
   - 個人帳號：jacky.personal@gmail.com
   
   有需要修改的嗎？
   ```

4. **測試基礎功能**：
   ```
   要不要測試一下基礎功能？
   1. 幫你排一個測試會議
   2. 檢查今天行程
   3. 查詢 Gmail 未讀郵件
   ```

---

## 📋 問卷檢查清單

完成訪談後，確認以下資訊都已收集：

### 基本資訊
- [ ] 用戶稱呼
- [ ] 溝通語言
- [ ] 工作性質
- [ ] 時區

### 帳號與工具
- [ ] Google 帳號列表
- [ ] 預設帳號
- [ ] 其他工作工具

### 工作偏好
- [ ] 溝通風格（簡短/詳細）
- [ ] Emoji 使用
- [ ] 授權範圍
- [ ] 主動性偏好
- [ ] 工作時間與勿擾時段

### 提醒設定
- [ ] 每日行程提醒（時間、格式）
- [ ] 郵件檢查（頻率、標準）

### 任務管理
- [ ] 現有任務管理方式
- [ ] AI 任務管理需求
- [ ] 優先順序定義

### 生活事件
- [ ] 固定生活事件
- [ ] 重要日期提醒

### 工作報告
- [ ] 是否需要每日報告
- [ ] 報告時間與格式

---

## 💡 訪談技巧

### 給 AI 的建議

1. **分批次進行**
   - 第一輪：基本資訊 + Google 帳號（Q1-Q7）
   - 第二輪：工作偏好（Q8-Q14）
   - 第三輪：行程與提醒（Q15-Q17）
   - 第四輪：任務與生活（Q18-Q23）
   - 第五輪：工作報告（Q24-Q25）

2. **根據回答調整**
   - 如果用戶說「不需要每日報告」→ 跳過 Q25
   - 如果用戶說「只有一個 Google 帳號」→ 跳過「預設帳號」問題

3. **用自然對話**
   - ❌ 不要：「Q1: 我該怎麼稱呼你？Q2: 你希望...」
   - ✅ 要：「我該怎麼稱呼你？」（等回答）→「好的，Jacky。你希望我主要用中文還是英文溝通？」

4. **確認理解**
   - 每一輪結束後：「好，我記下了：[摘要]。接下來問一下你的工作習慣...」

---

*這份問卷會隨著使用經驗持續優化。建議定期（每 1-2 個月）重新檢視設定是否需要調整。*
