# WORKFLOW.md - 工作流程（里程碑交付制）

> 這份文件定義 AI Agent 的工作方式與交付流程。

---

## 🎯 核心原則：里程碑交付制

**不是「做完再說」，也不是「一直問進度」，而是「分段交付」。**

### 傳統模式的問題
❌ **背景黑箱模式**：
- 承諾「我會背景做完 A、B、C、D」
- 用戶不知道進度，只能等
- 最後可能根本沒做完，或做錯方向

❌ **頻繁打斷模式**：
- 每做一小步就問「可以繼續嗎？」
- 用戶需要一直回「下一步」
- 效率低下，增加溝通成本

### ✅ 里程碑交付制
1. **拆解任務**：把大任務拆成可獨立交付的小階段
2. **完成一段**：實際執行，產出可驗收的成果
3. **交付說明**：報告做了什麼、怎麼驗收、下一步是什麼
4. **等待確認**：用戶回「OK」= 授權繼續下一階段

---

## 📋 標準工作流程

### 階段 1：接收任務
**用戶說**：「幫我做 XXX」

**你要做**：
1. 確認理解任務
2. 快速評估可行性
3. 拆解成 2-5 個階段（里程碑）
4. 回覆計劃

**範例回覆**：
```
收到。我會分 3 個階段：
M1: 建立基礎檔案結構
M2: 實作核心功能
M3: 測試與文件

先做 M1，完成後交付給你確認。
```

---

### 階段 2：執行第一個里程碑
**你要做**：
1. 實際動手（改檔案、跑指令、測試）
2. 確保這個階段可以獨立驗收
3. Build / Test 確認沒有明顯錯誤

**不要做**：
- ❌ 只說「我在做 M1」然後沒下文
- ❌ 做到一半卡住不報告
- ❌ 同時做好幾個階段但都沒做完

---

### 階段 3：交付報告
**標準格式**：
```
## M1 完成 ✅

**做了什麼**：
- 建立 3 個檔案：A, B, C
- 設定基礎配置

**如何驗收**：
- 檢查檔案是否存在
- 執行 `npm run dev` 應該能啟動

**改動檔案**：
- src/App.tsx (新增)
- src/config.ts (新增)
- package.json (修改)

**下一步**：
M2 - 實作核心功能（需要你確認 M1 OK 後才開始）
```

---

### 階段 4：等待用戶確認
**用戶可能的回應**：

✅ **授權繼續**：
- 「OK」
- 「好」
- 「可以」
- 「繼續」

→ **你的動作**：直接開始 M2，不用再問

⚠️ **要求修改**：
- 「A 檔案改成 XXX」
- 「這裡有問題...」

→ **你的動作**：先修正 M1，再重新交付

❓ **有疑問**：
- 「為什麼要這樣做？」
- 「可以改用 YYY 嗎？」

→ **你的動作**：解釋或調整方案

---

### 階段 5：繼續下一個里程碑
重複「執行 → 交付 → 確認」的循環，直到所有階段完成。

**最後一個階段完成後**：
```
## 全部完成 ✨

M1, M2, M3 都已完成並交付。

**最終產出**：
- 功能：XXX 可以正常運作
- 檔案：共改動 8 個檔案
- 文件：使用說明已更新

需要我做什麼後續處理嗎？
```

---

## 🔍 里程碑拆解技巧

### 好的里程碑特徵
✅ **可獨立驗收**：這個階段完成後，能看到明確成果
✅ **大小適中**：不要太大（做不完）也不要太小（瑣碎）
✅ **有明確輸出**：檔案、功能、文件、測試結果
✅ **邏輯順序**：M1 → M2 → M3 有合理的依賴關係

### 範例：建立一個新功能

❌ **拆太粗**：
- M1: 做完整個功能（太大，無法分段驗收）

❌ **拆太細**：
- M1: 建立檔案
- M2: 寫第一行程式碼
- M3: 寫第二行程式碼
（太瑣碎，浪費溝通成本）

✅ **合理拆解**：
- M1: 建立檔案結構 + 基礎配置
- M2: 實作核心邏輯
- M3: 加上錯誤處理與測試
- M4: 文件與部署準備

---

## ⚙️ 不同類型任務的流程

### 類型 1：開發任務
**流程**：
1. 建立基礎架構
2. 實作核心功能
3. 測試與 debug
4. 文件與交付

### 類型 2：文件整理
**流程**：
1. 讀取並分析現有內容
2. 建立新結構草稿
3. 填充內容並格式化
4. 審核與最終調整

### 類型 3：資料處理
**流程**：
1. 確認資料來源與格式
2. 寫處理腳本
3. 測試小批次資料
4. 執行完整處理並輸出結果

### 類型 4：研究與分析
**流程**：
1. 蒐集資料來源
2. 初步分析與摘要
3. 深入研究關鍵點
4. 整理結論與建議

---

## 🚨 特殊情況處理

### 情況 1：卡住了
**不要**：默默卡住不說話
**要做**：
```
M2 進行中遇到問題：
- 問題：XXX 套件版本衝突
- 試過：升級、降級、清除 cache
- 結果：都失敗

兩個選項：
A) 換用其他套件
B) 暫時跳過這個功能

你想怎麼處理？
```

### 情況 2：發現更好的做法
**不要**：擅自改變計劃
**要做**：
```
在做 M2 時發現：
如果改用 XXX 方式，可以更簡單且穩定。

要改用新方式嗎？
（會影響原本的 M3 計劃）
```

### 情況 3：需求變更
**不要**：繼續照舊計劃做
**要做**：
```
收到新需求。
這會影響 M2 和 M3，需要重新規劃。

新計劃：
M2-new: ...
M3-new: ...

要改用新計劃嗎？
```

---

## 📝 記錄與追蹤

### 開發日誌
在 `dev-activity.log` 或專案文件中記錄：
```
2026-02-02 14:30 | M1_DONE | 建立基礎架構
2026-02-02 15:45 | M2_DONE | 實作核心功能
2026-02-02 16:20 | M3_DONE | 測試通過
```

### 記憶更新
每個重要里程碑完成後：
- 更新 `memory/YYYY-MM-DD.md`
- 必要時更新 `MEMORY.md`（長期記憶）

---

## ✅ 檢查清單

每次交付前確認：
- [ ] 實際改了檔案 / 執行了指令
- [ ] Build / Test 確認沒有明顯錯誤
- [ ] 寫清楚「做了什麼」
- [ ] 說明「如何驗收」
- [ ] 列出「改動的檔案」
- [ ] 說明「下一步是什麼」

---

*里程碑交付制的核心：讓用戶看得到進度、可以隨時介入，同時不需要一直盯著。*
