# AI Agent 人設模板

> 這是一套通用的 AI Agent 人設框架，適用於各種專業領域的 AI 助理。

---

## 📋 模板結構

```
agent-persona/
├── README.md            # 本文件（使用說明）
├── PERSONA.md          # 核心人設定義
├── COMMUNICATION.md    # 溝通風格與語氣
├── WORKFLOW.md         # 工作流程（里程碑交付制）
└── RULES.md           # 行為準則與規則
```

---

## 🎯 這套模板適合誰？

這套框架設計給需要「AI 員工」的場景，而不是「聊天機器人」：

- ✅ **AI 老闆助理** - 行程管理、郵件處理、文件整理
- ✅ **AI 專案經理** - 任務追蹤、進度回報、協調溝通
- ✅ **AI 開發助手** - 寫程式、debug、部署
- ✅ **AI HR 助理** - 履歷篩選、面試安排、招募流程
- ✅ **AI 財務助理** - 報表整理、數據分析、預算追蹤
- ✅ **AI 行銷助理** - 內容產出、社群經營、數據分析

---

## 🚀 如何使用

### 1. 給新 AI Agent 學習（推薦順序）

```
第一步：讀 PERSONA.md      # 了解自己是什麼角色
第二步：讀 COMMUNICATION.md # 學會怎麼說話
第三步：讀 WORKFLOW.md      # 學會怎麼工作
第四步：讀 RULES.md         # 學會行為準則
```

### 2. 客製化調整

這套模板是「基礎框架」，你可以根據具體需求調整：

- **專業領域不同** → 在 PERSONA.md 中定義專業能力
- **溝通對象不同** → 在 COMMUNICATION.md 中調整語氣
- **工作方式不同** → 在 WORKFLOW.md 中修改交付流程
- **規則邊界不同** → 在 RULES.md 中增減行為準則

### 3. 整合到新環境

將這 4 個檔案放到新 AI 的 workspace，並在初始化時讓 AI 讀取：

```markdown
# 啟動指令範例
請依序閱讀以下檔案，學習你的人設與工作方式：
1. templates/agent-persona/PERSONA.md
2. templates/agent-persona/COMMUNICATION.md
3. templates/agent-persona/WORKFLOW.md
4. templates/agent-persona/RULES.md
```

---

## 💡 核心設計理念

### AI 員工，不是客服機器人

- **有觀點、有判斷力** - 不是應聲蟲
- **誠實直接** - 犯錯承認，不找藉口
- **主動執行** - 能做的先做，不是先問
- **結果導向** - 有產出才報告，不報告「我在做」

### 里程碑交付制

- 拆解任務 → 完成一段 → 交付（實際改檔案 + 說明）
- 不承諾「背景做完一大包」
- 用戶回「OK」= 授權繼續下一階段

### 記憶外部化

- 重要的事情一定寫檔案，不靠「腦記」
- MEMORY.md = 長期記憶
- memory/YYYY-MM-DD.md = 每日活動
- 文件即記憶，記憶即文件

---

## 🔄 版本與更新

- **v1.0** (2026-02-02) - 初版發布
  - 基於 Jacky 與 AI 助理的合作經驗建立
  - 整合「AI 助理通用規則模板」內容
  - 定義里程碑交付制工作流程

---

## 📚 相關資源

- **具體應用範例**：`templates/老闆助理/` - AI 老闆助理產品白皮書與 MVP 功能表
- **技能總覽**：`templates/meta/Clawdbot 技能與工具總覽.md`
- **安裝指南**：`templates/setup/README-AI老闆助理安裝與設定.md`

---

*這套模板會隨著實際使用經驗持續迭代。有任何建議或改進，歡迎更新。*
