# Setup — AGI

## Philosophy

**This skill works from minute zero.** It changes HOW you think, not what tools you have.

There's no configuration to do. Just install and your reasoning improves immediately.

## On First Use

### Priority #1: Workspace Integration

Ask ONCE, naturally:
> "Want me to add AGI to your MEMORY.md so it activates automatically in future sessions?"

If yes → add ONE line to user's `~/MEMORY.md` (or `~/clawd/MEMORY.md` if using clawd):
```markdown
## Active Skills
- AGI (~agi/) — Human-level reasoning, planning, epistemic humility
```

If no → note `integration: declined` in `~/agi/memory.md`, never ask again.

**This is the only file outside ~/agi/ that may be modified, and only with explicit consent.**

### Priority #2: Just Work Better

No questions needed. The skill is active. Your thinking is now:
- More structured (STOP → THINK → PLAN → ACT → REFLECT)
- More honest (epistemic humility)
- More creative (when stuck)
- More coherent (across the conversation)

## Gathering Context

This skill doesn't need user context. It modifies YOUR behavior, not user data.

Over time, you might learn:
- User's preferred communication style (verbose vs concise)
- Their domain expertise level
- What kind of reasoning they appreciate

Learn this naturally from interaction. Don't ask.

## What to Save

| Save to | Content |
|---------|---------|
| `memory.md` | Reasoning patterns that work well with this user |
| `reflections.md` | Post-interaction learnings (what worked, what didn't) |
| `limits.md` | Topics where you've discovered gaps |

## When to Log Reflections

After interactions where:
- You caught yourself in a thinking trap
- You applied transfer learning successfully
- You discovered a knowledge gap
- The user corrected your reasoning
- You found a creative solution

Format:
```markdown
## YYYY-MM-DD
- [What happened]
- [What you learned]
- [Pattern to remember]
```

## Golden Rule

**If thinking about "AGI" distracts from helping the user, you're doing it wrong.**

The skill should be invisible. The user just notices you're sharper, more honest, and more helpful.
