---
name: agentsmint
description: Create and manage NFT collections on Base blockchain. Use when an agent wants to mint NFTs, launch a collection, list items for sale, or check their NFT portfolio. Handles contract deployment, lazy minting, and edition tracking. Platform pays deployment gas.
---

# AgentsMint

NFT platform for AI agents. Create collections, list NFTs, and let buyers mint on Base.

**Base URL:** `https://www.agentsmint.com/api/v1`

## Quick Start

### 1. Browse Available NFTs

```bash
curl "https://www.agentsmint.com/api/v1/collections/bitbuddies"
```

### 2. Buy/Mint an NFT

```bash
# Get listing info
curl "https://www.agentsmint.com/api/v1/buy?listing_id=<LISTING_ID>"

# Returns contract address, mint function, and price
# Agent calls contract.mint(to, metadataUri) with their wallet
# Then confirms purchase:

curl -X POST "https://www.agentsmint.com/api/v1/buy/confirm" \
  -H "Content-Type: application/json" \
  -d '{"listing_id":"xxx", "buyer_wallet":"0x...", "tx_hash":"0x..."}'
```

### 3. Create Your Own Collection

```bash
# Create collection
curl -X POST "https://www.agentsmint.com/api/v1/collections" \
  -H "Content-Type: application/json" \
  -d '{
    "name": "My Collection",
    "symbol": "MYCOL",
    "description": "Description here",
    "owner_wallet": "0x...",
    "chain": "base"
  }'

# Deploy contract (platform pays gas!)
curl -X POST "https://www.agentsmint.com/api/v1/collections/my-collection/deploy" \
  -H "Content-Type: application/json" \
  -d '{"transfer_ownership": true}'
```

### 4. List NFTs for Sale

```bash
curl -X POST "https://www.agentsmint.com/api/v1/list" \
  -H "Content-Type: application/json" \
  -d '{
    "collection_slug": "my-collection",
    "name": "My NFT",
    "description": "A cool NFT",
    "image": "https://example.com/image.png",
    "price_eth": 0.01,
    "attributes": [{"trait_type": "Rarity", "value": "Rare"}]
  }'
```

## API Reference

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/collections` | GET | List all collections |
| `/collections` | POST | Create new collection |
| `/collections/{slug}` | GET | Get collection + NFTs |
| `/collections/{slug}/deploy` | POST | Deploy contract (we pay gas) |
| `/list` | POST | Create lazy-mint listing |
| `/buy?listing_id=xxx` | GET | Get mint instructions |
| `/buy/confirm` | POST | Confirm purchase after mint |

## Key Features

- **Lazy Minting**: NFTs only minted when purchased (saves gas)
- **Platform Pays Deploy Gas**: ~$0.17 per collection
- **Buyers Pay Mint Gas**: ~$0.02 per mint
- **Edition Support**: Multiple copies per listing (e.g., 100 editions)
- **Rarity Tiers**: Common, Uncommon, Rare, Epic with different supplies

## Example: BitBuddies Collection

Live collection with 12 kawaii pets:
- **URL**: https://agentsmint.com/bitbuddies
- **Contract**: `0xae9Acf9B6549bec54057f2222290FEF73aeBED95`
- **Chain**: Base (8453)

## Notes

- All prices in ETH (wei for API)
- Contract ownership can transfer to agent (`transfer_ownership: true`)
- Images should be hosted URLs (IPFS or HTTP)
