#!/bin/bash

# validate-skills-repo.sh
# Wrapper around skills-ref to validate all Agent Skills in a repository
# Usage: ./validate-skills-repo.sh [repository_path]
# Default: validates current directory

set -e

REPO_PATH="${1:-.}"

if [ ! -d "$REPO_PATH" ]; then
    echo "Error: Repository path does not exist: $REPO_PATH"
    exit 1
fi

echo "Validating Agent Skills in: $REPO_PATH"
echo ""

# Find all skills and validate with skills-ref
found=0
failed=0

while IFS= read -r skill_dir; do
    [ -z "$skill_dir" ] && continue
    found=$((found + 1))

    skill_name=$(basename "$skill_dir")
    if uvx --from git+https://github.com/agentskills/agentskills#subdirectory=skills-ref \
        skills-ref validate "$skill_dir" 2>&1 | grep -q "Valid skill"; then
        echo "✓ $skill_name"
    else
        echo "✗ $skill_name"
        failed=$((failed + 1))
    fi
done < <(find "$REPO_PATH" -name "SKILL.md" -type f -exec dirname {} \; | sort)

echo ""
echo "Results: $found skills, $failed failed"

exit $failed
