# Agent Skills Specification

**Official Spec**: https://agentskills.io/specification

## Required Fields

| Field | Type | Constraints | Format |
|-------|------|-------------|--------|
| `name` | string | 1-64 chars | `^[a-z0-9]+(-[a-z0-9]+)*$` |
| `description` | string | 1-1024 chars | Include "Use when..." |

## Optional Fields

| Field | Type | Constraints | Purpose |
|-------|------|-------------|---------|
| `license` | string | SPDX ID | `Apache-2.0`, `MIT`, `Proprietary` |
| `compatibility` | string | ≤500 chars | Environment requirements |
| `metadata` | object | key-value | `author`, `version`, `category`, `tags`, `dependencies` |
| `allowed-tools` | string | space-delimited | Pre-authorized CLI tools (experimental) |

## File Structure

```
skill-name/
├── SKILL.md          # Required: frontmatter + instructions
├── scripts/          # Optional: executable scripts  
├── references/       # Optional: extended docs (loaded on-demand)
└── assets/           # Optional: templates, diagrams
```

## Validation Rules

**Frontmatter**: Valid YAML, `---` delimiters, required fields present, correct types/lengths
**Content**: Valid Markdown after frontmatter, UTF-8 encoded, not empty
**Files**: `SKILL.md` exists (exact case), readable permissions

## Common Errors

| Error | Fix |
|-------|-----|
| Invalid name chars | Use only `a-z`, `0-9`, `-` (no leading/trailing/consecutive hyphens) |
| Description too long | Keep under 1024 chars, move details to body |
| Invalid YAML | Quote special chars, consistent indentation, quote versions (`"1.0"`) |

## Progressive Disclosure

| Stage | Content | Tokens | Loading |
|-------|---------|--------|---------|
| Discovery | name + description | ~100 | Startup |
| Activation | Full SKILL.md | <5000 | On invoke |
| Deep dive | references/ | Variable | On-demand |

**Refactoring**: If >500 lines, extract to `references/` and `assets/`, link from main skill.

## Minimal Valid Skill

```yaml
---
name: example-skill
description: Brief description. Use when doing X.
---
# Example Skill
Instructions here.
```
