# Agent Skills Examples

## Style Comparison

### Terse Style (Reference Skills)

Use for: API docs, color palettes, command references, configuration guides.

```yaml
---
name: brand-guidelines
description: Apply brand colors and typography. Use when styling outputs with company identity.
---
# Brand Styling

## Colors
- Dark: `#141413`
- Light: `#faf9f5`
- Accent: `#d97757`

## Typography
- Headings: Poppins (24pt+)
- Body: Lora

## Usage
Apply dark background with light text, or light background with dark text.
```

**Characteristics**:
- <100 lines
- Bullet lists, not prose
- Values inline, no explanation needed
- No examples section (self-evident)

### Methodology Style (Process Skills)

Use for: Debugging workflows, development practices, deployment processes.

```yaml
---
name: systematic-debugging
description: Use when encountering bugs, test failures, or unexpected behavior.
---
# Systematic Debugging

## Overview
Find root cause before attempting fixes. Symptom fixes are failure.

## The Iron Law
NO FIXES WITHOUT ROOT CAUSE INVESTIGATION FIRST

## When to Use
- Test failures
- Bugs in production
- Unexpected behavior

## Four Phases
1. **Root Cause** - Read errors, reproduce, trace data flow
2. **Pattern Analysis** - Find working examples, compare
3. **Hypothesis** - Form theory, test minimally
4. **Implementation** - Create test, fix, verify

## Common Rationalizations
| Excuse | Reality |
|--------|---------|
| "Too simple" | Simple bugs have root causes |
| "No time" | Systematic is faster than thrashing |

## Red Flags - STOP
- "Quick fix for now"
- "Just try changing X"
- Proposing fixes without investigation
```

**Characteristics**:
- 200-400 lines acceptable
- Tables for quick reference
- Good/Bad examples
- Rationalizations section
- Red Flags checklist

## CSO: Claude Search Optimization

### Critical Rule

**Description = When to Use, NOT What the Skill Does**

When description summarizes workflow, agents may follow description instead of reading full skill.

### Bad Descriptions

```yaml
# ❌ Summarizes workflow - agent follows this shortcut
description: Use when executing plans - dispatches subagent per task with code review

# ❌ Too much process detail
description: Use for TDD - write test first, watch it fail, write minimal code, refactor

# ❌ Vague
description: Helps with PDFs
```

### Good Descriptions

```yaml
# ✅ Triggering conditions only
description: Use when executing implementation plans with independent tasks

# ✅ Symptoms, not process
description: Use when tests have race conditions or pass/fail inconsistently

# ✅ Concrete triggers
description: Extract text and tables from PDF files. Use when processing documents.
```

## Minimal Skill (PDF Text Extraction)

```yaml
---
name: extract-pdf-text
description: Extract text from PDF documents. Use when processing uploads or preparing for RAG.
---
# PDF Text Extraction

## When to Use
- Processing uploaded documents
- Ingesting invoices or reports
- Preparing PDFs for RAG pipelines

## Quick Start
```bash
python scripts/extract.py input.pdf > output.txt
```

## Troubleshooting
- **Scanned PDF**: Use OCR first
- **Encrypted**: Decrypt before extraction
```

## Standard Skill (AWS Lambda)

```yaml
---
name: deploy-lambda
description: Deploy Python functions to AWS Lambda. Use for serverless APIs or event processors.
license: Apache-2.0
compatibility: AWS CLI 2.x, Python 3.9+
metadata:
  author: agentic-insights
  version: "1.0.0"
allowed-tools: bash aws zip python
---
# AWS Lambda Deployment

## Prerequisites
- AWS CLI configured
- IAM role ARN for Lambda

## Quick Deploy
```bash
python scripts/deploy.py --function-name my-fn --handler handler.main
```

## Troubleshooting
| Issue | Fix |
|-------|-----|
| Size limit | Use Lambda Layers |
| Timeout | Increase (max 900s) |
| AccessDenied | Add `lambda:CreateFunction` permission |
```

## Progressive Disclosure Skill (K8s)

```yaml
---
name: k8s-deploy
description: Deploy apps to Kubernetes with health checks. Use for microservices on K8s.
license: Apache-2.0
compatibility: kubectl, helm 3.x
---
# Kubernetes Deployment

## Quick Deploy
```bash
python scripts/deploy.py --app my-api --image registry/api:v1
```

## References
- [Deployment patterns](references/patterns.md)
- [Configuration](references/config.md)
- [Troubleshooting](references/troubleshooting.md)
```

Main SKILL.md stays under 50 lines; details in references/.

## Token Efficiency

| Skill Type | Target | Location |
|------------|--------|----------|
| Getting-started | <150 words | Always loaded |
| Frequently-used | <200 words | Often loaded |
| Standard | <500 words | On-demand |
| Complex | <200 words main | + references/ |

## Key Patterns

| Pattern | Lines | When |
|---------|-------|------|
| Terse | <100 | Reference data, configs |
| Standard | 100-300 | Most skills |
| Methodology | 200-400 | Processes, workflows |
| Progressive | <200 main | Complex domains |
