# Agent Skills Best Practices

## Writing Instructions

| Principle | Bad | Good |
|-----------|-----|------|
| Be imperative | "You might want to check..." | "Check if file exists: `test -f config.json`" |
| Be concrete | "Deploy with appropriate config" | `python deploy.py --env prod --region us-east-1` |
| Show outputs | "Run the command" | Show expected success/error output |
| Handle errors | Skip error cases | Include troubleshooting section |

## Document Structure

```markdown
# Skill Name (2-3 sentence overview)
## Prerequisites (list requirements)
## Quick Start (minimal example)
## Complete Workflow (step-by-step)
## Troubleshooting (common issues)
## Advanced Usage (optional)
```

## Progressive Disclosure

| Location | Content | Size |
|----------|---------|------|
| SKILL.md | Overview, quick start, common issues | <500 lines |
| references/ | API docs, extended examples, architecture | On-demand |
| assets/ | Templates, configs, diagrams | Static files |

**Refactor when**: >500 lines, >3 examples, detailed API docs, advanced config

## Cross-Platform Compatibility

- **Avoid**: "Ask Claude to...", "Use Cursor's search...", "Use the Bash tool..."
- **Prefer**: "Run this command: `...`", "Search codebase for...", "Execute: `...`"
- **Test**: Claude Code, Cursor, GitHub Copilot (pick 2+)

## Security

- **No hardcoded secrets** - Use env vars or secrets managers
- **Validate inputs** - Include validation step before destructive ops
- **Least privilege** - Document minimal required permissions
- **Audit trails** - Log deployments and changes

## Versioning

```yaml
metadata:
  version: "2.1.3"  # MAJOR.MINOR.PATCH
```

- **MAJOR**: Breaking changes
- **MINOR**: New features (backward compatible)
- **PATCH**: Bug fixes

## Quality Checklist

- [ ] `skills-ref validate` passes
- [ ] Prerequisites explicit
- [ ] At least one runnable example
- [ ] Error handling documented
- [ ] Expected outputs shown
- [ ] Tested with 2+ AI agents
- [ ] LICENSE file included
- [ ] Platform-agnostic language

## Antipatterns

| Antipattern | Problem |
|-------------|---------|
| Vague instructions | Agent can't execute |
| Assuming context | Missing prerequisites |
| No error handling | Agent stuck on failure |
| Complex first example | Overwhelms users |

## Resources

- Spec: https://agentskills.io/specification
- Examples: https://github.com/agentskills/agentskills/tree/main/skills
- Validator: https://github.com/agentskills/agentskills/tree/main/skills-ref
