---
name: your-skill-name
description: Brief description of what this skill does and when to use it. Include keywords for agent discovery.
license: Apache-2.0
metadata:
  author: your-org
  version: "1.0.0"
---

# Your Skill Name

Brief overview of what this skill accomplishes (2-3 sentences).

## Prerequisites

List everything required before using this skill:
- Software dependencies (with versions)
- Environment requirements
- Credentials or access requirements
- Configuration files

Example:
- Python 3.10+
- AWS CLI 2.x configured
- Valid AWS credentials with Lambda permissions
- Docker installed and running

## Quick Start

Minimal example to get started quickly:

```bash
# Example command
python scripts/deploy.py --config config.yaml
```

**Expected Output**:
```
Deployment successful!
Function ARN: arn:aws:lambda:us-east-1:123456789012:function:my-function
```

## Complete Workflow

### Step 1: Preparation

Detailed first step with context:

```bash
# Command with explanation
python scripts/prepare.py --input data.json
```

What this does: [explanation]

### Step 2: Execution

Detailed second step:

```bash
# Main command
python scripts/execute.py --verbose
```

**Expected Output**:
```
[Show what success looks like]
```

### Step 3: Verification

How to confirm the operation succeeded:

```bash
# Verification command
python scripts/verify.py --status
```

## Examples

### Example 1: Basic Usage

**Scenario**: [Describe the use case]

**Steps**:
1. First action: `command-1`
2. Second action: `command-2`
3. Verify result: `command-3`

**Expected Outcome**: [What should happen]

### Example 2: Advanced Usage

**Scenario**: [Describe more complex use case]

**Steps**:
[Detailed steps]

**Expected Outcome**: [What should happen]

## Configuration

Key configuration options:

- **`option_name`**: Description of what this controls
  - Type: string
  - Default: `default-value`
  - Example: `example-value`

For complete configuration reference, see [references/configuration.md](references/configuration.md).

## Troubleshooting

### Common Issues

**Issue**: "Error message here"

**Cause**: Why this error occurs

**Solution**:
1. Step to diagnose: `diagnostic-command`
2. Step to fix: `fix-command`
3. Verify fix: `verify-command`

---

**Issue**: "Another error message"

**Cause**: [Explanation]

**Solution**:
[Steps to resolve]

## Advanced Topics

For advanced usage patterns, see:
- [Advanced configuration](references/advanced-config.md)
- [Performance tuning](references/performance.md)
- [Integration patterns](references/integration.md)

## Related Skills

This skill works well with:
- [related-skill-1](../related-skill-1/SKILL.md) - Brief description
- [related-skill-2](../related-skill-2/SKILL.md) - Brief description

## Resources

- Official documentation: [link]
- API reference: [link]
- Community examples: [link]
