---
name: agentskills-io
description: Create, validate, and publish Agent Skills following the official open standard from agentskills.io. Use when (1) creating new skills for AI agents, (2) validating skill structure and metadata, (3) understanding the Agent Skills specification, (4) converting existing documentation into portable skills, or (5) ensuring cross-platform compatibility with Claude Code, Cursor, GitHub Copilot, and other tools.
license: Apache-2.0
metadata:
  author: agentic-insights
  version: "1.0"
  spec-url: https://agentskills.io/specification
  reference-repo: https://github.com/agentskills/agentskills
---

# Agent Skills (agentskills.io)

Create portable skills for AI agents. Works with Claude Code, Cursor, GitHub Copilot, OpenAI integrations, VS Code (symlinks enable sharing across tools).

## Resources
- Specification: https://agentskills.io/specification | Validator: https://github.com/agentskills/agentskills

## Structure
```
skill-name/
├── SKILL.md          # Required (frontmatter + instructions, <5000 tokens activation)
├── scripts/          # Optional: executable code
├── references/       # Optional: detailed docs
└── assets/           # Optional: templates, static files
```

**Rules**: Dir name = frontmatter `name:`. Only 3 subdirs. SKILL.md <500 lines. ~100 tokens for discovery (name+desc).

## Frontmatter

### Required
- `name`: 1-64 chars, lowercase alphanumeric-hyphens (`^[a-z0-9]+(-[a-z0-9]+)*$`)
- `description`: 1-1024 chars, include "Use when..." (discovery budget: ~100 tokens)

### Optional
- `license`: SPDX identifier (Apache-2.0, MIT) | `compatibility`: Environment reqs (<500 chars)
- `metadata`: Key-value pairs (author, version, tags) | `allowed-tools`: Space-delimited tool list

## Validation
```bash
# Install permanently (vs ephemeral uvx)
uv tool install git+https://github.com/agentskills/agentskills#subdirectory=skills-ref
# Or use uvx for one-shot validation
uvx --from git+https://github.com/agentskills/agentskills#subdirectory=skills-ref skills-ref validate ./skill
```

| Command | Description |
|---------|-------------|
| `skills-ref validate <path>` | Check structure, frontmatter, token budgets |
| `skills-ref read-properties <path>` | Extract metadata |
| `skills-ref to-prompt <path>` | Generate prompt format |

## Writing Rules
- Imperative language: "Check: `command`" not "You might want to..."
- Concrete examples with expected output; handle common errors with solutions
- Progressive disclosure: core in SKILL.md (<5000 tokens), details in references/

## Common Errors

| Error | Fix |
|-------|-----|
| Invalid name | Lowercase alphanumeric-hyphens only |
| Missing description | Add `description:` field with "Use when..." |
| Description too long | <1024 chars, move details to body |
| Invalid YAML | Check indentation, quote special chars |
| Missing SKILL.md | Filename must be exactly `SKILL.md` |
| Dir name mismatch | Directory name must match `name:` field |

## Quick Workflow
1. Create: `mkdir skill-name && touch skill-name/SKILL.md`
2. Add frontmatter (name, description with "Use when...")
3. Write instructions (bullets, not prose); validate: `skills-ref validate ./skill-name`
4. Test with AI agent, iterate; add LICENSE, push to repository

## Plugin Structure (Claude Code)
```
plugin-name/
├── .claude-plugin/plugin.json
├── README.md, LICENSE, CHANGELOG.md  # CHANGELOG.md tracks versions
├── skills/skill-name/SKILL.md
├── agents/     # Optional: subagents (.md files)
└── examples/   # Optional: full demo projects
```

**Distinctions**: Plugin `examples/` = runnable projects. Skill `assets/` = static resources only.

## Batch Validation & Versioning
```bash
bash scripts/validate-skills-repo.sh     # Validate all skills in repo
bash scripts/bump-changed-plugins.sh     # Auto-bump only changed plugins (semver)
```

## Minimal Example
```yaml
---
name: example-skill
description: Brief description. Use when doing X.
---
# Example Skill
## Prerequisites
- Required tools
## Instructions
1. First step: `command`
2. Second step with example
## Troubleshooting
**Error**: Message → **Fix**: Solution
```

## Symlink Sharing
Share skills across Claude Code, Cursor, VS Code: `ln -s /path/to/skills ~/.cursor/skills`

## References
- [specification.md](references/specification.md) - Full YAML schema, token budgets
- [examples.md](references/examples.md) - Complete examples across platforms
- [validation.md](references/validation.md) - Error troubleshooting
- [best-practices.md](references/best-practices.md) - Advanced patterns, symlink setup
