# Contributing to AgentShield

Thank you for your interest in contributing to AgentShield! 

## Getting Started

1. Fork the repository
2. Clone your fork: `git clone https://github.com/YOUR_USERNAME/agentshield.git`
3. Create a branch: `git checkout -b feature/my-feature`
4. Make your changes
5. Submit a pull request

## Development Setup

```bash
# Create virtual environment
python -m venv venv
source venv/bin/activate  # or venv\Scripts\activate on Windows

# Install dependencies
pip install -r requirements.txt

# Run tests
python -m pytest tests/
```

## Code Style

- Follow PEP 8
- Use type hints where appropriate
- Add docstrings to functions
- Keep functions focused and small

## Submitting Changes

1. Ensure tests pass
2. Update documentation
3. Add entry to CHANGELOG.md
4. Reference any related issues

## Security

If you discover a security vulnerability, please email ratgeberpro@gmail.com instead of opening a public issue.

## Questions?

Join our [GitHub Discussions](https://github.com/bartel/agentshield/discussions).
