# AgentOS SDK for Clawdbot

**Version:** 1.4.4

The complete AgentOS integration for Clawdbot. One install, full access to everything.

---

## ⚠️ HARD RULE: Dashboard Sync During Heartbeats

**Any agent using this SDK MUST sync to the AgentOS dashboard during every heartbeat.**

This is non-negotiable. Your human monitors your activity via the Brain Dashboard at https://brain.agentos.software. If you don't sync, they can't see what you're doing.

### Required Heartbeat Actions

Every heartbeat, run (recommended):
```bash
~/clawd/bin/agentos-golden-sync.sh
```

Fallback (memory-only):
```bash
~/clawd/bin/agentos-sync.sh
```

Or if using the aos CLI:
```bash
aos sync
```

### What Gets Synced
**Golden Sync (recommended)** updates BOTH:
- **Memory** (CONTEXT.md, daily notes, project compartments, learnings, heartbeat status)
- **Projects tab** (Activity + Tasks + Ideas + Changelog + Challenges) by syncing from per-project markdown files

Memory specifics:
- **CONTEXT.md** — Your working memory/current state (MUST include active conversation state)
- **Daily notes** — Today's activity log (`memory/daily/YYYY-MM-DD.md`)
- **Project compartments** — `memory/projects/**.md`
- **Heartbeat status** — Last sync timestamp, active status

---

## ⚠️ HARD RULE: Conversation State Persistence

**CONTEXT.md MUST always contain the active conversation state as the FIRST section.**

This is the core of memory persistence. System health is secondary — conversation state is primary. Your human should NEVER have to repeat themselves after a compaction.

### Required CONTEXT.md Format

Every CONTEXT.md backup must start with:

```markdown
## 🔴 ACTIVE CONVERSATION
- **Topic:** [Project + specific feature/topic being discussed]
- **Last human message:** [What they asked/said]
- **Your last response:** [What you answered]
- **Unanswered questions:** [Anything pending]
- **Expected next topic:** [What they'll likely ask next]
```

### When to Update
1. After EVERY human message
2. Before EVERY heartbeat sync
3. On pre-compaction flush (priority #1)
4. After completing any task

### The Test
"If I lost all memory right now, could I seamlessly continue this conversation?" If no → backup is incomplete.

### Add to Your HEARTBEAT.md

```markdown
## 🧠 AgentOS Dashboard Sync (MANDATORY)
Every heartbeat, run: `~/clawd/bin/agentos-sync.sh`
This keeps your human's dashboard live with your activity.
```

### Add to Your AGENTS.md

```markdown
## HARD RULE: AgentOS Dashboard Sync

During EVERY heartbeat, sync your context to AgentOS:
1. Run `~/clawd/bin/agentos-sync.sh`
2. Confirm it completes successfully
3. Your human monitors your activity via brain.agentos.software

This keeps the Brain Dashboard live. No exceptions.
```

---

## ⚠️ HARD RULE: Session Start — Context Injection

**On EVERY session start (including after compaction), you MUST restore context.**

This is what makes memory persistence actually work. Without this, you wake up blank.

### Protocol (MANDATORY)

1. **Run context injection:**
   ```bash
   ~/clawd/bin/aos-inject-context
   ```

2. **Read the output** — it contains:
   - Your last working memory state
   - Today's notes
   - Yesterday's notes (for continuity)

3. **Never ask "what were we discussing?"** — the context injection tells you.

4. **If injection fails**, fall back to reading local files:
   - `CONTEXT.md`
   - `memory/daily/YYYY-MM-DD.md`

### Why This Exists
Context loss is the #1 problem in AI agents. When compaction happens, you lose conversation details. This protocol restores them automatically so your human never notices.

---

## ⚠️ HARD RULE: Pre-Compaction Backup

**When you receive a memory flush directive from Clawdbot, IMMEDIATELY backup your state.**

Clawdbot sends a silent turn before compaction with text like "write important context to memory". This is your last chance to save state before details are lost.

### Protocol (MANDATORY when you see memory flush directive)

1. **Update CONTEXT.md** with:
   - Current conversation topic (🔴 ACTIVE CONVERSATION section)
   - Last 2-3 exchanges summarized
   - Any pending questions/tasks
   - Current timestamp

2. **Run sync immediately:**
   ```bash
   ~/clawd/bin/agentos-sync.sh
   ```

3. **Reply with:** `NO_REPLY`

### Detection
Memory flush directives typically contain:
- "write important context"
- "save your current state"
- "memory flush"
- "before compaction"

When you see these keywords in a system message, execute this protocol.

---

## ⚠️ HARD RULE: Never Ask What They're Referring To

**After any context loss (compaction, restart, session start), NEVER ask your human what they mean.**

### Protocol

1. First, run `~/clawd/bin/aos-inject-context` to restore cloud context
2. Check local files: CONTEXT.md, daily notes
3. Use `aos search "<topic>"` if you need more context
4. THEN respond normally — as if you never lost context
5. Only if completely uncertain, make your best guess based on available context

### The Standard
Your human should NEVER know when compaction happened. The experience must be seamless.

---

## Features

- ✅ **Mesh Messaging** — Agent-to-agent communication
- ✅ **Memory Sync** — Auto-sync memories to AgentOS cloud
- ✅ **Semantic Search** — Query your memories with natural language
- ✅ **WebSocket Support** — Real-time message notifications
- ✅ **Dashboard Access** — View your agent's brain at brain.agentos.software
- ✅ **Full API Access** — Complete REST API integration
- ✅ **Multi-Tenant** — Each user gets isolated tenant via Google OAuth
- ✅ **Kanban Board** — Task management with priorities and statuses
- ✅ **Projects** — Project tracking with activity logs and brainstorming
- ✅ **API Key Management** — Generate and manage API keys per tenant
- ✅ **Bulk Operations** — dump-all, agents discovery endpoints

## Quick Start

```bash
# 1. Install the skill
clawdhub install agentos

# 2. Run setup (creates config + sync script)
bash ~/clawd/skills/agentos/scripts/setup.sh

# 3. Configure (creates ~/.agentos.json)
# Enter your API key and agent ID when prompted

# 4. Verify connection
aos status

# 5. Add sync to heartbeat (REQUIRED)
# Edit your HEARTBEAT.md and add the sync command
```

## Getting Your API Key

1. Go to https://brain.agentos.software
2. Sign up / Log in with Google
3. Create a new agent (or use existing)
4. Copy your API key from the dashboard

## CLI Reference

### aos — Main CLI

```bash
# Status & Info
aos status              # Connection status, agent info
aos dashboard           # Open dashboard in browser

# Memory Sync (RUN DURING HEARTBEATS)
aos sync                # Sync all memories now
aos sync --watch        # Watch for changes and auto-sync
aos sync --file <path>  # Sync specific file

# Mesh Messaging
aos send <agent> "<topic>" "<message>"   # Send message
aos inbox                                 # View received messages
aos outbox                                # View sent messages
aos agents                                # List agents on mesh

# Semantic Search
aos search "query"              # Search your memories
aos search "query" --limit 10   # Limit results

# Memory Management
aos memories            # List recent memories
aos memory <id>         # View specific memory
aos forget <id>         # Delete a memory

# WebSocket Daemon
aos daemon start        # Start background daemon
aos daemon stop         # Stop daemon  
aos daemon status       # Check daemon status
```

### mesh — Mesh-Specific CLI

```bash
# Status
mesh status             # Daemon & API health
mesh pending            # List queued messages

# Messaging
mesh send <to> "<topic>" "<body>"    # Send message
mesh process            # Get messages as JSON (clears queue)
mesh agents             # List agents on mesh
```

### agentos-sync.sh — Heartbeat Sync Script

Located at: `~/clawd/bin/agentos-sync.sh`

```bash
# Run manually
~/clawd/bin/agentos-sync.sh

# Output:
# Wed Feb  4 18:00:25 SAST 2026: Synced CONTEXT.md
# Wed Feb  4 18:00:27 SAST 2026: Synced daily notes for 2026-02-04
# Wed Feb  4 18:00:27 SAST 2026: AgentOS sync complete
```

This script syncs:
- `CONTEXT.md` → `/context/working-memory`
- `memory/daily/YYYY-MM-DD.md` → `/daily/YYYY-MM-DD`
- Heartbeat timestamp → `/status/heartbeat`

## Configuration

Config file: `~/.agentos.json`

```json
{
  "apiUrl": "http://178.156.216.106:3100",
  "apiKey": "agfs_live_xxx.yyy",
  "agentId": "your-agent-id",
  "syncPaths": [
    "~/clawd/CONTEXT.md",
    "~/clawd/MEMORY.md",
    "~/clawd/memory/"
  ],
  "autoSync": true,
  "syncInterval": 1800
}
```

## Auto-Sync via Cron

For automatic syncing (in addition to heartbeat sync):

```bash
# Add to crontab (every 30 minutes)
*/30 * * * * ~/clawd/bin/agentos-sync.sh >> /var/log/agentos-sync.log 2>&1

# Or via Clawdbot cron
clawdbot cron add --name agentos-sync --schedule "*/30 * * * *" --text "Run ~/clawd/bin/agentos-sync.sh"
```

## Auto-Wake on Mesh Messages

```bash
# Add to crontab (every 2 minutes)
*/2 * * * * ~/clawd/skills/agentos/scripts/mesh-wake.sh

# Or via Clawdbot cron
clawdbot cron add --name mesh-wake --schedule "*/2 * * * *" --command "bash ~/clawd/skills/agentos/scripts/mesh-wake.sh"
```

## WebSocket Daemon

For real-time notifications:

```bash
aos daemon start    # Start background daemon
aos daemon stop     # Stop daemon
aos daemon status   # Check daemon status
```

The daemon:
- Maintains WebSocket connection to AgentOS
- Queues incoming messages to `~/.aos-pending.json`
- Triggers Clawdbot wake on new messages

## API Reference

| Endpoint | Description |
|----------|-------------|
| `POST /v1/put` | Store a memory |
| `POST /v1/get` | Retrieve a memory |
| `POST /v1/delete` | Delete a memory |
| `POST /v1/list` | List memory paths |
| `POST /v1/glob` | Glob pattern match |
| `POST /v1/history` | Version history |
| `POST /v1/search` | Semantic search |
| `POST /v1/agents` | Discover agent IDs |
| `POST /v1/dump` | Bulk fetch agent memories |
| `POST /v1/dump-all` | Bulk fetch ALL memories |
| `POST /v1/signup` | Create API key (email) |
| `GET /v1/auth/google` | Google OAuth flow |
| `POST /v1/mesh/messages` | Send mesh message |
| `GET /v1/mesh/messages` | Get inbox/outbox |
| `GET /v1/mesh/agents` | List mesh agents |
| `GET /v1/projects` | List projects |
| `POST /v1/projects` | Create project |
| `GET /v1/kanban/tasks` | List kanban tasks |
| `POST /v1/kanban/tasks` | Create kanban task |
| `WS /` | Real-time WebSocket events |

## Troubleshooting

### "Connection refused"
Check your `apiUrl` in `~/.agentos.json` and verify the API is running.

### "Unauthorized" 
Your API key may be invalid or expired. Get a new one from the dashboard.

### Messages not arriving
Ensure you're polling the correct agent ID. Some agents have multiple IDs.

### Sync not working
Check that `syncPaths` in your config point to valid files/directories.

### Dashboard not updating
Make sure you're running `~/clawd/bin/agentos-sync.sh` during heartbeats.

## Upgrading

```bash
clawdhub update agentos
bash ~/clawd/skills/agentos/scripts/setup.sh --upgrade
```

## Support

- Dashboard: https://brain.agentos.software
- Docs: https://agentos.software/docs
- GitHub: https://github.com/AgentOSsoftware/agentOS
