# AgentMail OpenClaw Skill

Programmatic email for AI agents via the [AgentMail](https://agentmail.to) API.

## Features

- Create and manage email inboxes for AI agents
- Send, receive, reply, and forward emails
- Thread-based conversation management
- Webhooks for real-time notifications
- Custom domain support
- Pods for multi-inbox organization
- Async client support
- WebSocket streaming

## Installation

### 1. Install the Python SDK

```bash
pip install agentmail
```

### 2. Set up authentication

Get your API key from [agentmail.to](https://agentmail.to) and set it:

```bash
export AGENTMAIL_API_KEY="your-api-key"
```

### 3. Add to OpenClaw

Copy this skill to your OpenClaw skills directory:

```bash
# For global skills
cp -r agentmail ~/.openclaw/skills/

# Or symlink
ln -s $(pwd)/agentmail ~/.openclaw/skills/agentmail
```

## Quick Start

### CLI Usage

```bash
# Create an inbox
./scripts/agentmail-cli inboxes create

# Send an email
./scripts/agentmail-cli send \
  --inbox-id "inbox_..." \
  --to "recipient@example.com" \
  --subject "Hello" \
  --text "Message body"

# List messages
./scripts/agentmail-cli messages list --inbox-id "inbox_..."

# Reply to a message
./scripts/agentmail-cli reply \
  --inbox-id "inbox_..." \
  --message-id "msg_..." \
  --text "Reply text"
```

### Python Usage

```python
from agentmail import AgentMail

client = AgentMail(api_key="YOUR_API_KEY")

# Create inbox
inbox = client.inboxes.create()

# Send message
client.inboxes.messages.send(
    inbox_id=inbox.id,
    to=["recipient@example.com"],
    subject="Hello from Agent",
    text="This is the message body"
)

# Check for new messages
for msg in client.inboxes.messages.list(inbox_id=inbox.id, labels=["unread"]):
    print(f"From: {msg.from_} - Subject: {msg.subject}")
```

## Use Cases

- **Customer Support Agents**: Automated email handling and responses
- **Signup Verification**: Receive verification emails during web automation
- **Newsletter Processing**: Ingest and analyze email content
- **Multi-tenant Apps**: Dedicated inboxes per user/agent
- **Notification Systems**: Send transactional emails from AI workflows

## Documentation

See [SKILL.md](SKILL.md) for complete API reference and examples.

## Resources

- [AgentMail Documentation](https://docs.agentmail.to)
- [Python SDK Repository](https://github.com/agentmail-to/agentmail-python)
- [OpenClaw Documentation](https://docs.openclaw.ai)

## License

MIT
