# AgenticMail Configuration

## Quick Setup

Run `agenticmail openclaw` to configure everything automatically.

## Environment Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `AGENTICMAIL_MASTER_KEY` | (generated) | Master API key |
| `AGENTICMAIL_API_PORT` | `3100` | API server port |
| `AGENTICMAIL_API_HOST` | `127.0.0.1` | API bind address |
| `AGENTICMAIL_DATA_DIR` | `~/.agenticmail` | Data directory |

## Config File

Location: `~/.agenticmail/config.json`

Generated by `agenticmail setup`. Contains all settings including generated keys.

## OpenClaw Plugin Config

In `~/.openclaw/openclaw.json`:

```json
{
  "plugins": {
    "entries": {
      "agenticmail": {
        "enabled": true,
        "config": {
          "apiUrl": "http://127.0.0.1:3100",
          "apiKey": "ak_...",
          "masterKey": "mk_..."
        }
      }
    },
    "load": {
      "paths": ["/path/to/@agenticmail/openclaw"]
    }
  }
}
```

## MCP Server Config

In `.mcp.json` (for MCP clients like Cursor, Windsurf, etc.):

```json
{
  "mcpServers": {
    "agenticmail": {
      "command": "npx",
      "args": ["@agenticmail/mcp"],
      "env": {
        "AGENTICMAIL_API_URL": "http://127.0.0.1:3100",
        "AGENTICMAIL_API_KEY": "ak_..."
      }
    }
  }
}
```

## Docker Ports

| Port | Service |
|------|---------|
| 8080 | Stalwart HTTP (Admin + JMAP) |
| 587 | SMTP Submission (STARTTLS) |
| 143 | IMAP |
| 25 | SMTP |
| 3100 | AgenticMail API |
