---
name: agentic-x402
description: Make x402 payments to access gated APIs and content. Fetch paid resources, check wallet balance, and create payment links. Use when encountering 402 Payment Required responses or when the user wants to pay for web resources with crypto.
license: MIT
compatibility: Requires Node.js 20+, network access to x402 facilitators and EVM chains
homepage: https://www.npmjs.com/package/agentic-x402
metadata: {"author": "monemetrics", "version": "0.2.6", "openclaw": {"requires": {"bins": ["x402"], "env": ["EVM_PRIVATE_KEY"]}, "primaryEnv": "EVM_PRIVATE_KEY", "install": [{"id": "node", "kind": "node", "package": "agentic-x402", "bins": ["x402"], "label": "Install agentic-x402 (npm)"}]}}
allowed-tools: Bash(x402:*) Bash(npm:*) Read
---

# x402 Agent Skill

Pay for x402-gated APIs and content using USDC on Base. This skill enables agents to autonomously make crypto payments when accessing paid web resources.

## Quick Reference

| Command | Description |
|---------|-------------|
| `x402 setup` | Create or configure wallet |
| `x402 balance` | Check USDC and ETH balances |
| `x402 pay <url>` | Pay for a gated resource |
| `x402 fetch <url>` | Fetch with auto-payment |
| `x402 create-link` | Create payment link (seller) |
| `x402 link-info <addr>` | Get payment link details |

## Installation

```bash
npm i -g agentic-x402
```

Once installed, the `x402` command is available globally:

```bash
x402 --help
x402 --version
```

## Setup

Run the interactive setup to create a new wallet:

```bash
x402 setup
```

This will:
1. Generate a new wallet (recommended) or accept an existing key
2. Save configuration to `~/.x402/.env`
3. Display your wallet address for funding

**Important:** Back up your private key immediately after setup!

### Manual Configuration

Alternatively, set the environment variable directly:

```bash
export EVM_PRIVATE_KEY=0x...your_private_key...
```

Or create a config file:

```bash
mkdir -p ~/.x402
echo "EVM_PRIVATE_KEY=0x..." > ~/.x402/.env
chmod 600 ~/.x402/.env
```

Verify setup:

```bash
x402 balance
```

## Paying for Resources

### When you encounter HTTP 402 Payment Required

Use `x402 pay` to make the payment and access the content:

```bash
x402 pay https://api.example.com/paid-endpoint
```

The command will:
1. Check payment requirements
2. Verify amount is within limits
3. Process the payment
4. Return the gated content

### Automatic payment with fetch

Use `x402 fetch` for seamless payment handling:

```bash
x402 fetch https://api.example.com/data --json
```

This wraps fetch with x402 payment handling - if the resource requires payment, it's handled automatically.

### Payment limits

By default, payments are limited to $10 USD. Override with `--max`:

```bash
x402 pay https://expensive-api.com/data --max 50
```

Or set globally:
```bash
export X402_MAX_PAYMENT_USD=25
```

### Dry run

Preview payment without executing:

```bash
x402 pay https://api.example.com/data --dry-run
```

## Creating Payment Links (Seller)

Create payment links to monetize your own content using x402-links-server:

### Setup for link creation

Add to `.env`:
```bash
X402_LINKS_API_URL=https://your-x402-links-server.com
```

### Create a link

Gate a URL:
```bash
x402 create-link --name "Premium API" --price 1.00 --url https://api.example.com/premium
```

Gate text content:
```bash
x402 create-link --name "Secret" --price 0.50 --text "The secret message..."
```

With webhook notification:
```bash
x402 create-link --name "Guide" --price 5.00 --url https://mysite.com/guide --webhook https://mysite.com/payment-hook
```

### Get link info

```bash
x402 link-info 0x1234...5678
x402 link-info https://21.cash/pay/0x1234...5678
```

## Command Reference

### x402 balance

Check wallet balances.

```bash
x402 balance [--json] [--full]
```

| Flag | Description | Default |
|------|-------------|---------|
| `--json` | Output as JSON (address, network, chainId, balances) | — |
| `--full` | Show full wallet address instead of truncated | — |
| `-h, --help` | Show help | — |

### x402 pay

Pay for an x402-gated resource.

```bash
x402 pay <url> [options]
```

| Flag | Description | Default |
|------|-------------|---------|
| `<url>` | The URL of the x402-gated resource (positional) | **required** |
| `--method` | HTTP method | `GET` |
| `--body` | Request body (for POST/PUT requests) | — |
| `--header` | Add custom header (can be used multiple times) | — |
| `--max` | Maximum payment in USD (overrides config) | from config |
| `--dry-run` | Show payment details without paying | — |
| `-h, --help` | Show help | — |

### x402 fetch

Fetch with automatic payment.

```bash
x402 fetch <url> [options]
```

| Flag | Description | Default |
|------|-------------|---------|
| `<url>` | The URL to fetch (positional) | **required** |
| `--method` | HTTP method | `GET` |
| `--body` | Request body (for POST/PUT) | — |
| `--header` | Add header as `"Key: Value"` | — |
| `--json` | Output as JSON only (for piping to other tools) | — |
| `--raw` | Output raw response body only (no headers or status) | — |
| `-h, --help` | Show help | — |

### x402 create-link

Create a payment link.

```bash
x402 create-link --name <name> --price <usd> [options]
```

| Flag | Description | Default |
|------|-------------|---------|
| `--name` | Name of the payment link | **required** |
| `--price` | Price in USD (e.g., `"5.00"` or `"0.10"`) | **required** |
| `--url` | URL to gate behind payment | — |
| `--text` | Text content to gate behind payment | — |
| `--desc` | Description of the link | — |
| `--webhook` | Webhook URL for payment notifications | — |
| `--json` | Output as JSON | — |
| `-h, --help` | Show help | — |

> **Note:** Either `--url` or `--text` is required. The link is deployed as a smart contract on Base.

### x402 link-info

Get payment link details.

```bash
x402 link-info <router-address> [--json]
```

| Flag | Description | Default |
|------|-------------|---------|
| `<address>` | Router contract address or full payment URL (positional) | **required** |
| `--json` | Output as JSON | — |
| `-h, --help` | Show help | — |

## Environment Variables

| Variable | Description | Default |
|----------|-------------|---------|
| `EVM_PRIVATE_KEY` | Wallet private key (0x-prefixed) | **required** |
| `X402_NETWORK` | `mainnet` (Base, chain 8453) or `testnet` (Base Sepolia, chain 84532) | `mainnet` |
| `X402_MAX_PAYMENT_USD` | Safety limit — payments exceeding this are rejected unless `--max` is used | `10` |
| `X402_FACILITATOR_URL` | Custom facilitator URL | Coinbase (mainnet) / x402.org (testnet) |
| `X402_SLIPPAGE_BPS` | Slippage tolerance in basis points (100 bps = 1%) | `50` |
| `X402_VERBOSE` | Enable verbose logging (`1` = on, `0` = off) | `0` |
| `X402_LINKS_API_URL` | Base URL of x402-links-server (e.g., `https://21.cash`) | — |

## Supported Networks

| Network | Chain ID | CAIP-2 ID |
|---------|----------|-----------|
| Base Mainnet | 8453 | eip155:8453 |
| Base Sepolia | 84532 | eip155:84532 |

## Payment Token

All payments use **USDC** (USD Coin) on the selected network.

- Base Mainnet: `0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913`
- Base Sepolia: `0x036CbD53842c5426634e7929541eC2318f3dCF7e`

## How x402 Works

1. Client requests a resource
2. Server responds with `402 Payment Required` + payment details
3. Client signs a payment authorization (USDC transfer)
4. Client retries request with payment signature
5. Server verifies payment via facilitator
6. Server settles payment on-chain
7. Server returns the gated content

The x402 protocol is gasless for buyers - the facilitator sponsors gas fees.

## Troubleshooting

### "Missing required environment variable: EVM_PRIVATE_KEY"

Set your wallet private key:
```bash
export EVM_PRIVATE_KEY=0x...
```

Or create a `.env` file in your working directory, or install globally and use `~/.x402/.env`.

### "Payment exceeds max limit"

Increase the limit:
```bash
x402 pay https://... --max 50
```

### Low balance warnings

Fund your wallet with:
- **USDC** for payments
- **ETH** for gas (small amount, ~0.001 ETH)

### Network mismatch

Ensure your wallet has funds on the correct network:
- `X402_NETWORK=mainnet` → Base mainnet
- `X402_NETWORK=testnet` → Base Sepolia

## Backup Your Private Key

Your private key is stored in `~/.x402/.env`. If lost, your funds cannot be recovered.

### Recommended Backup Methods

1. **Password Manager** (Recommended)
   - Store in 1Password, Bitwarden, or similar
   - Create a secure note with your private key
   - Tag it for easy retrieval

2. **Encrypted File**
   ```bash
   # Encrypt with GPG
   gpg -c ~/.x402/.env
   # Creates ~/.x402/.env.gpg - store this backup securely
   ```

3. **Paper Backup** (for larger amounts)
   - Write down the private key
   - Store in a safe or safety deposit box
   - Never store digitally unencrypted

### View Your Private Key

```bash
cat ~/.x402/.env | grep EVM_PRIVATE_KEY
```

### Recovery

To restore from backup:
```bash
mkdir -p ~/.x402
echo "EVM_PRIVATE_KEY=0x...your_backed_up_key..." > ~/.x402/.env
chmod 600 ~/.x402/.env
x402 balance  # verify
```

## Security Best Practices

- **Use a dedicated wallet** — Never use your main wallet with automated agents
- **Limit funds** — Only transfer what you need for payments
- **Set payment limits** — Configure `X402_MAX_PAYMENT_USD` to cap exposure
- **Test first** — Use `X402_NETWORK=testnet` with test tokens before mainnet
- **Protect the config** — `~/.x402/.env` has 600 permissions; keep it that way
- **Never share** — Your private key gives full access to your wallet

## Links

- [x402 Protocol Docs](https://docs.x402.org/)
- [x402 GitHub](https://github.com/coinbase/x402)
- [npm: agentic-x402](https://www.npmjs.com/package/agentic-x402)
- [Base Network](https://base.org/)
