---
name: agentic-workflow-automation
description: Generate reusable multi-step agent workflow blueprints. Use for trigger/action orchestration, deterministic workflow definitions, and automation handoff artifacts.
---

# Agentic Workflow Automation

## Overview

Build workflow blueprints that can be translated into automation platforms such as n8n or internal orchestrators.

## Workflow

1. Define workflow name, trigger, and ordered steps.
2. Normalize each step into a simple execution contract.
3. Build a blueprint with dependencies and execution order.
4. Export JSON/markdown artifacts for implementation.

## Use Bundled Resources

- Run `scripts/generate_workflow_blueprint.py` for deterministic workflow output.
- Read `references/workflow-blueprint-guide.md` for step design guidance.

## Guardrails

- Keep each step single-purpose.
- Include clear fallback behavior for failed steps.
