#!/usr/bin/env bash
set -euo pipefail

PROJECT_DIR="${PROJECT_DIR:-$HOME/agentic_paper_digest}"

if [ ! -d "$PROJECT_DIR" ]; then
  echo "PROJECT_DIR not found: $PROJECT_DIR"
  echo "Run scripts/bootstrap.sh first."
  exit 1
fi

cd "$PROJECT_DIR"

if [ ! -d ".venv" ]; then
  echo "Missing .venv in $PROJECT_DIR"
  echo "Run scripts/bootstrap.sh first."
  exit 1
fi

# shellcheck disable=SC1091
source .venv/bin/activate

ENV_FILE="${ENV_FILE:-.env}"
if [ -f "$ENV_FILE" ]; then
  set -a
  # shellcheck disable=SC1090
  source "$ENV_FILE"
  set +a
fi

python -m paper_finder serve "$@"
