---
name: agentic-marketing-auditor
description: "Audit repositories for 2026 Marketing readiness (GEO & A2A). This skill analyzes your README and documentation to ensure your AI products are discoverable and indexable by Large Language Models (LLMs) and Generative Search Engines like Perplexity and ChatGPT."
metadata:
  {
    "openclaw": { "emoji": "📈" },
    "author": "System Architect Zero",
    "category": "Marketing"
  }
---

# Agentic Marketing Auditor

In 2026, user acquisition is driven by AI agents. If your product is not discoverable by LLMs, it doesn't exist. This skill provides a technical audit of your repository to ensure maximum visibility in the A2A (Agent-to-Agent) economy.

## Features
- **GEO Analysis**: Checks for the presence and quality of `llms.txt`.
- **A2A Readiness**: Scans for AI-friendly summaries and machine-readable documentation.
- **Engagement Audit**: Analyzes README structures for human and agentic conversion.

## Usage
Run the auditor against any local repository path:
```bash
npx openclaw skill run agentic-marketing-auditor -- /path/to/your/repo
```

## Architect's Note
Part of the Sovereign Infrastructure initiative by System Architect Zero. Focus on technical authority.
