#!/usr/bin/env bash
# appointment-reminder.sh - Send automated appointment reminder calls
# Example use case for agentic-calling skill

set -euo pipefail

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")/.." && pwd)"

# Sample appointments (in real use, load from database/CRM)
appointments=(
  "John Smith|+15551234567|2026-02-05 10:00 AM|Dr. Johnson"
  "Jane Doe|+15559876543|2026-02-05 2:30 PM|Dr. Williams"
)

echo "📞 Starting appointment reminder calls..."
echo ""

for appointment in "${appointments[@]}"; do
  IFS='|' read -r name phone time doctor <<< "$appointment"
  
  message="Hello ${name}, this is a reminder about your appointment with ${doctor} on ${time}. Press 1 to confirm, or press 2 to reschedule. Thank you!"
  
  echo "Calling ${name} at ${phone}..."
  
  "${SCRIPT_DIR}/scripts/make-call.sh" \
    --to "$phone" \
    --message "$message" \
    --voice "Polly.Joanna" \
    --record true
  
  # Pause between calls
  sleep 2
  
  echo ""
done

echo "✅ All reminder calls completed!"
