# Agentic Calling - Quick Start

Enable your AI agent to make and receive phone calls autonomously.

## Installation

1. **Install via ClawdHub:**
```bash
clawdhub install agentic-calling
```

2. **Configure Twilio Credentials:**

Create `~/.clawdbot/twilio-config.json`:
```json
{
  "accountSid": "YOUR_ACCOUNT_SID",
  "authToken": "YOUR_AUTH_TOKEN",
  "phoneNumber": "+1XXXXXXXXXX"
}
```

Or set environment variables:
```bash
export TWILIO_ACCOUNT_SID="ACxxxxxxxxx"
export TWILIO_AUTH_TOKEN="your_auth_token"
export TWILIO_PHONE_NUMBER="+15551234567"
```

3. **Make scripts executable:**
```bash
chmod +x scripts/*.sh
```

## Quick Examples

### Make a call:
```bash
./scripts/make-call.sh \
  --to "+15551234567" \
  --message "Hello! This is your AI assistant calling with an important update."
```

### Send an SMS:
```bash
./scripts/sms-notify.sh \
  --to "+15551234567" \
  --message "Your AI assistant tried to call you. Please call back."
```

### Check call status:
```bash
./scripts/call-status.sh --list --limit 5
```

## Documentation

See [SKILL.md](SKILL.md) for complete documentation, advanced usage, and examples.

## Getting Twilio Credentials

1. Sign up at [twilio.com](https://www.twilio.com)
2. Buy a phone number with Voice capabilities (~$1/month)
3. Get your Account SID and Auth Token from the console

## Cost

- Phone number: ~$1.15/month
- Outbound calls: ~$0.013/minute
- Inbound calls: ~$0.0085/minute
- SMS: ~$0.0079/message

## Support

- Full docs: [SKILL.md](SKILL.md)
- Twilio docs: https://www.twilio.com/docs
- Report issues: GitHub Issues
