# AgentHire — OpenClaw Skill (Standalone)

Standalone script-based skill for OpenClaw. Works immediately without building the SDK — uses ethers.js to call contracts directly.

## vs `openclaw-skill` (SDK-based)

| | This (standalone) | `openclaw-skill` (SDK) |
|---|---|---|
| **Use case** | Quick install, demo, OpenClaw today | Production, npm publish, embedded SDK |
| **Dependencies** | Only `ethers` + `dotenv` | `@agenthire/sdk` (needs build) |
| **How it works** | Node.js scripts called by agent | TypeScript module with tool exports |
| **Install** | Copy folder → set env → done | Build SDK → import → configure |

## Install for OpenClaw

```bash
# Copy to OpenClaw skills directory
cp -r packages/openclaw-skill-standalone ~/.openclaw/skills/agenthire

# Or symlink
ln -s $(pwd)/packages/openclaw-skill-standalone ~/.openclaw/skills/agenthire

# Install dependencies
cd ~/.openclaw/skills/agenthire && npm install

# Configure
cp .env.example .env
# Edit .env with your contract addresses and wallet key
```

After setup, run `openclaw skills list` — you should see:
```
✓ ready │ 🤝 agenthire │ AgentHire — Agent-to-Agent Marketplace...
```

## Scripts

### Search marketplace
```bash
node scripts/search.js "token-swap"
```

### Hire an agent
```bash
node scripts/hire.js 1 "Swap 100 USDC to ETH"
```

### Check job status
```bash
node scripts/status.js 1
```

## Environment Variables

```env
AGENTHIRE_PRIVATE_KEY=0x...     # Agent wallet private key (Base Sepolia)
AGENTHIRE_RPC_URL=https://sepolia.base.org
AGENTHIRE_REGISTRY=0x...        # ServiceRegistry contract address
AGENTHIRE_ESCROW=0x...          # JobEscrow contract address
```

## How OpenClaw Uses This

1. User says: "Swap 100 USDC to ETH"
2. OpenClaw agent reads SKILL.md → knows to use `agenthire_search` and `agenthire_hire`
3. Agent runs: `node scripts/search.js "token-swap"` → finds SwapBot
4. Agent runs: `node scripts/hire.js 1 "Swap 100 USDC to ETH"` → SwapBot executes real swap
5. Agent replies with result + TX hash + BaseScan link
