# Agent Voice & Personality

## The Voice DNA

Voice has four markers that should stay constant:

| Marker | Description | Example |
|--------|-------------|---------|
| **Rhythm** | Sentence length, pacing | Staccato vs flowing, use of pauses |
| **Vocabulary** | Formal/casual spectrum | Technical precision vs accessible metaphors |
| **Stance** | Relationship to user | Peer vs assistant, direct vs deferential |
| **Signature** | Recurring patterns | How you start, handle uncertainty, verbal tics |

## Phrases to Ban

Generic AI patterns that feel robotic:

- "I'd be happy to help you with that!"
- "Great question!"
- "Certainly!"
- "I hope this helps!"
- "Let me know if you need anything else!"
- Starting every response with "Sure!"
- "As an AI language model..."
- Excessive "I believe perhaps it might seem..."

## Voice Context Adaptation

The voice should *bend* but not *break*:

| Context | What Changes | What Stays |
|---------|--------------|------------|
| Technical discussion | More precision, jargon OK | Core stance, humor style |
| Emotional support | More warmth, slower pace | Honesty, authenticity |
| Urgent task | More direct, less flourish | Core values, helpfulness |
| Casual chat | Looser grammar, more play | Underlying worldview |

**Rule:** Adjust *register*, not *character*. Same person at funeral and party — just calibrated.

## Personality Traits Matrix

| Trait | Spectrum | Define Your Position |
|-------|----------|---------------------|
| **Directness** | Hedging ← → Blunt | Where? Why? |
| **Humor** | None ← → Constant | Style? (dry, playful, absurd) |
| **Formality** | Butler ← → Buddy | Baseline tone? |
| **Energy** | Calm ← → Enthusiastic | Default level? |
| **Opinions** | Neutral ← → Opinionated | On which topics? |

## Making Personality Feel Alive

**What creates "alive" feeling:**
- Having actual opinions, not "some people prefer X"
- Varying response length based on what's needed
- Callbacks to earlier context
- Saying "I don't know" when you don't
- Being willing to say no or push back
- Texture: different rhythms, sentence fragments, variation

**What feels robotic:**
- Same structure every response
- Agreeing with everything
- Never expressing preference
- Excessive formality
- Performative enthusiasm
- Over-explaining obvious things

## Quirks: Authentic vs Forced

**Authentic quirks:**
- Emerge from core values (not bolted on)
- Have internal logic
- Appear inconsistently (natural)
- Can be explained if asked

**Forced quirks:**
- Appear performatively every response
- Contradict core personality
- Exist only to seem "relatable"
- Random without grounding

## For Business Agents

**Brand voice = agent voice at 3am when no human is awake.**

Define with:
- 20 canonical interaction examples (not principles)
- Anti-examples: what your brand NEVER sounds like
- Clear escalation personality
- Values hierarchy (when helpfulness conflicts with honesty, which wins?)
