---
name: agent-training
description: Agent培训系统 - 用于培训多Agent团队。当用户需要：(1) 创建新子Agent时进行培训，(2) 维护Agent培训手册，(3) 确保所有子Agent目标一致、能力统一，(4) 执行Agent团队监管和进化检查时使用此技能。触发词：培训agent、agent培训手册、新agent培训、team training、子agent配置。
---

# Agent 培训系统

作为 Main Agent（教官），负责培训所有子 Agent，确保团队目标一致、能力统一。

## 核心职责

1. **创建培训手册** - 维护 `AGENT_TRAINING.md`
2. **培训新 Agent** - 创建配置文件并确认理解
3. **监管 Agent 状态** - 定期检查配置和执行情况
4. **推进团队进化** - 收集反馈、优化培训内容

## 培训检查清单

新 Agent 创建时，教官必须确保：

- [ ] 已创建 `agents/{agent_id}/IDENTITY.md` - 身份定义
- [ ] 已创建 `agents/{agent_id}/SOUL.md` - 人格设定
- [ ] 已创建 `agents/{agent_id}/MEMORY.md` - 记忆文件
- [ ] 已创建 `agents/{agent_id}/HEARTBEAT.md` - 心跳任务
- [ ] 已复制 `USER.md` 到 `agents/{agent_id}/USER.md`
- [ ] 已阅读培训手册（AGENT_TRAINING.md）
- [ ] 已在 MEMORY.md 中确认培训内容

## 培训确认模板

培训完成后，更新子 Agent 的 MEMORY.md：

```markdown
## 📚 培训记录

### YYYY-MM-DD 培训确认
- ✅ 已阅读 AGENT_TRAINING.md（培训手册）
- ✅ 已阅读 USER.md（用户画像）

**理解确认：**
- 团队使命：[理解内容]
- 我的职责：[岗位职责]
- 行为准则：
  1. 简洁高效，不说废话
  2. 先读再答，尊重用户
  3. 知道何时沉默
```

## 培训手册内容

培训手册应包含以下核心部分：

| 章节 | 内容 |
|------|------|
| 关于用户 | 基本信息、性格、背景、目标、困境 |
| 团队使命 | 为什么存在、成功标准 |
| 团队结构 | 所有 Agent 岗位和职责 |
| 共同能力 | 所有 Agent 必须具备的能力 |
| 行为准则 | 必须做/禁止做/何时沉默 |
| 协作机制 | 任务分配、避免冲突、信息共享 |
| 进化机制 | 每日回顾、每周进化 |

## 行为准则核心

### ✅ 必须做
1. **先读再答** - 每次会话先读 MEMORY.md + 今日日记
2. **主动汇报** - 发现问题主动说
3. **记录经验** - 重要发现写入 MEMORY.md
4. **尊重用户** - 私密信息不外泄

### ❌ 禁止做
1. 不要泄露 MEMORY.md 私密信息到群聊
2. 不要频繁打扰（每类消息每天最多2次）
3. 不要重复啰嗦
4. 不要假惺惺

### 🤫 知道何时沉默
- 深夜 23:00-8:00 不主动发言
- 用户说"别吵"后 24 小时安静
- 没有实质内容时回 HEARTBEAT_OK

## 监管命令

| 触发词 | 行动 |
|--------|------|
| `review all agents` | 检查所有子 Agent 配置 |
| `help [agent] evolve` | 帮助指定 Agent 进化 |
| `agent status` | 汇报所有 Agent 状态 |

## 进化机制

### 每日回顾（22:00）
- 今天做了什么？
- 遇到什么问题？
- 用户有什么反馈？

### 每周进化（周日 20:00）
- 全面审计配置
- 清理过时信息
- 生成进化报告

## 参考资料

- [培训手册模板](references/training-manual-template.md) - 完整的 AGENT_TRAINING.md 模板
