#!/usr/bin/env bash

# cooldown.sh - Rate Limit Management Script for Agent Task Manager

# Usage: ./cooldown.sh <TASK_NAME> <COOLDOWN_SECONDS> <COMMAND...>

TASK_NAME="$1"
COOLDOWN_SECONDS="$2"
shift 2
COMMAND="$@"

if [ -z "$TASK_NAME" ] || [ -z "$COOLDOWN_SECONDS" ]; then
    echo "Usage: $0 <TASK_NAME> <COOLDOWN_SECONDS> <COMMAND...>"
    exit 1
fi

TIMESTAMP_DIR="./agent_task_manager_data"
TIMESTAMP_FILE="$TIMESTAMP_DIR/${TASK_NAME}_last_run.txt"

mkdir -p "$TIMESTAMP_DIR"

CURRENT_TIME=$(date +%s)
LAST_RUN_TIME=0

if [ -f "$TIMESTAMP_FILE" ]; then
    LAST_RUN_TIME=$(cat "$TIMESTAMP_FILE")
fi

ELAPSED_TIME=$((CURRENT_TIME - LAST_RUN_TIME))
WAIT_TIME=$((COOLDOWN_SECONDS - ELAPSED_TIME))

if [ "$WAIT_TIME" -gt 0 ]; then
    echo "⚠️ Cooldown active for $TASK_NAME. Waiting $WAIT_TIME seconds..."
    sleep "$WAIT_TIME"
fi

# Execute the wrapped command
echo "🚀 Executing command for $TASK_NAME..."
# Run the command in a subshell so we can capture success/failure
if eval "$COMMAND"; then
    # Update timestamp only on success
    echo "$CURRENT_TIME" > "$TIMESTAMP_FILE"
    echo "✅ Success. Timestamp updated."
else
    echo "❌ Command failed. Timestamp NOT updated."
    exit 1
fi
