# references/task_schema.md - Task Structure Schema

This document defines the JSON structure for a long-running, multi-step task to be consumed by the Agent Task Manager's `orchestrator.py`.

## Task Root Object

| Field | Type | Required | Description |
| :--- | :--- | :--- | :--- |
| `task_name` | String | Yes | Unique identifier for the task (used for persistence). |
| `description` | String | Yes | Human-readable goal of the task. |
| `workflow` | Object | Yes | Dictionary defining the steps of the process. |
| `rate_limit` | Object | No | Parameters for rate-limit management (if required). |

## Workflow Object (Steps)

The `workflow` is a dictionary where keys are step names (e.g., `step_1`) and values are objects defining the step.

| Field | Type | Required | Description |
| :--- | :--- | :--- | :--- |
| `role` | String | Yes | The name of the specialized agent/tool to execute (e.g., `FinancialAnalyst`, `NotificationAgent`). |
| `action` | String | Yes | The specific action the role must take (e.g., `CHECK_WHALE_PERCENT`, `SEND_MESSAGE`). |
| `dependency` | String | No | Name of the step that must complete before this step runs. |
| `...params` | Any | No | Any required parameters for the action (e.g., `target_mint`, `threshold_percent`). |

## Rate Limit Object

| Field | Type | Required | Description |
| :--- | :--- | :--- | :--- |
| `period_seconds` | Integer | Yes | The minimum time (in seconds) between full task executions. |
| `cooldown_key` | String | Yes | The unique key used by `cooldown.sh` to track the last run time. |

---
**Example Structure (Whale Alert):**

```json
{
  "task_name": "WHALE_ALERT_SHIPYARD",
  "description": "Monitor $SHIPYARD whale and alert human via Signal if balance drops to critical level.",
  "workflow": {
    "step_1": {
      "role": "FinancialAnalyst",
      "action": "CHECK_WHALE_PERCENT",
      "target_mint": "7hhAuM18KxYETuDPLR2q3UHK5KKkiQdY1DQNqKGLCpump",
      "threshold_percent": 10
    },
    "step_2": {
      "role": "NotificationAgent",
      "action": "SEND_MESSAGE",
      "channel": "signal",
      "message": "URGENT: Whale Alert!",
      "dependency": "step_1"
    }
  },
  "rate_limit": {
    "period_seconds": 600,
    "cooldown_key": "SHIPYARD_WHALE_CHECK"
  }
}
```