---
name: agent-task-manager
description: Manages and orchestrates multi-step, stateful agent workflows; handles task dependencies, persistent state, error recovery, and external rate-limiting. Use for creating new multi-agent systems, improving sequential workflows, or managing time-bound actions.
---

# Agent Task Manager

## Overview

This skill provides the structure and primitives for building resilient, complex, and professional multi-agent systems within the OpenClaw environment. It transforms simple scripts into production-ready workflows.

## Core Capabilities

### 1. **Orchestration and Task State**

- **Capability:** Defines tasks with clear inputs, outputs, and dependencies (DAG-like structure).
- **Execution:** Uses `molt_task.py` to manage state in `task_state.json`.
- **Value:** Prevents redundant work, allows agents to resume mid-workflow after a session reset.

### 2. **External Rate-Limit Management**

- **Capability:** Manages the cooldown and retry logic for externally rate-limited actions (e.g., API posts, web scrapes).
- **Execution:** Uses the `scripts/cooldown.sh` wrapper to store last-executed timestamps and automatically wait/retry.
- **Value:** Ensures continuous operation in environments like Moltbook without violating API rules.

### 3. **Modular Role-Based Agents**

- **Capability:** Provides a template structure for specialized roles (e.g., `ContractAuditor`, `FinancialAnalyst`).
- **Execution:** Modules are designed to be run independently or sequenced by the Orchestrator.
- **Value:** Enables the creation of focused, expert agents for complex tasks like the MoltFinance-Auditor.

## Example Workflow: MoltFinance-Auditor

1. **Task:** `FinancialAudit`
2. **Dependencies:**
   - **Role 1:** `ContractAuditor` (Input: Contract Address, Output: Contract Safety Score)
   - **Role 2:** `FinancialAnalyst` (Input: Contract Address + Safety Score, Output: Trust Score)
3. **External Action:** `MoltbookPost` (Dependent on final Trust Score; subject to Rate Limit).

## Resources

### scripts/
- **`molt_task.py`**: Python class for task state management.
- **`cooldown.sh`**: Shell wrapper for managing rate-limited executions.

### references/
- **`workflow_schema.md`**: JSON schema for defining complex task dependencies.
- **`rate_limit_patterns.md`**: Guide to handling common API rate limits (e.g., Moltbook, Helius).
