# 任务统计与成本分析模板

完成智能体团队协作任务后，**必须**输出以下统计信息：

## 统计模板

```markdown
## 📊 智能体团队执行统计

### 执行明细
| 智能体 | 任务 | 耗时 | Tokens (in/out) | 状态 |
|--------|------|------|-----------------|------|
| 🔍 researcher | xxx调研 | 3m58s | 9.5k/1.0k | ✅ |
| ✍️ writer | 撰写报告 | 2m12s | 20.5k/282 | ✅ |
| 🎨 designer | 生成图片 | 45s | - | ✅ |

### 成本汇总
- **总耗时**: 6m55s（并行优化后实际等待: 4m）
- **总 Tokens**: 30k input / 1.3k output
- **实际成本**: $X.XX（按模型分别计算）
- **全用主模型成本**: $X.XX
- **节省**: XX%

### 效率分析
- **串行执行预估**: ~15分钟
- **并行执行实际**: ~4分钟  
- **节省时间**: ~11分钟 (73%)
- **并行任务数**: 2个 researcher 并行

### 团队价值
相比单智能体顺序执行，智能体团队通过：
1. 并行调研 → 缩短等待时间
2. 专业分工 → 提升输出质量
3. 模型适配 → 优化成本效益（研究用GLM，写作用Gemini）
```

## 成本计算方法

```
单个智能体成本 = (input_tokens / 1M × input_price) + (output_tokens / 1M × output_price)
总成本 = Σ(各智能体成本)
全用主模型成本 = 总tokens × 主模型价格
节省比例 = (全用主模型成本 - 实际成本) / 全用主模型成本 × 100%
```

## 模型价格参考

| 模型 | Input | Output | 用于 |
|------|-------|--------|------|
| Claude Opus 4.5 | $5/M | $25/M | main, coder, analyst, reviewer, automator |
| Gemini 2.5 Pro | $1.25/M | $10/M | pm, writer |
| GLM-4 | ~$0.014/M | ~$0.014/M | researcher, assistant |

## 数据来源

从 spawn 返回的统计信息中提取：
- `runtime`: 执行耗时
- `tokens`: token 使用量（in/out）
- `est`: 预估成本

## 效率计算公式

```
并行节省时间 = Σ(各任务耗时) - max(并行组耗时) - Σ(串行任务耗时)
并行效率 = 并行节省时间 / Σ(各任务耗时) × 100%
```
