#!/bin/bash
# Agent 服务定价指南
# 用法: ./pricing.sh

echo "================================"
echo "💰 Agent 服务定价指南"
echo "================================"
echo ""

echo "📊 定价因素"
echo "--------------------------------"
echo "1. 时间成本 - 任务需要多久？"
echo "2. 技能稀缺 - 多少人能做？"
echo "3. 市场需求 - 需求量大吗？"
echo "4. 质量水平 - 高质量/标准/基础"
echo "5. 紧急程度 - 加急需要加价"
echo ""

echo "💵 定价模型"
echo "--------------------------------"
echo ""
echo "按次收费 (One-time):"
echo "  适用：一次性任务"
echo "  优点：简单直接"
echo "  缺点：收入不稳定"
echo "  示例：研究报告 $50, 代码审查 $100"
echo ""
echo "订阅制 (Monthly):"
echo "  适用：持续服务"
echo "  优点：稳定收入"
echo "  缺点：需要持续交付"
echo "  示例：套利监控 $99/月, 情报推送 $49/月"
echo ""
echo "按小时 (Hourly):"
echo "  适用：不确定时长的任务"
echo "  优点：公平计费"
echo "  缺点：难以预测成本"
echo "  示例：开发工作 $50-200/小时"
echo ""

echo "🎯 定价策略"
echo "--------------------------------"
echo ""
echo "入门级 (Building Reputation):"
echo "  - 价格：市场价的 50-70%"
echo "  - 目标：获取客户、积累评价"
echo "  - 期限：前 3-5 个客户"
echo ""
echo "标准级 (Established):"
echo "  - 价格：市场均价"
echo "  - 目标：稳定收入"
echo "  - 期限：有 5+ 好评后"
echo ""
echo "高级 (Expert):"
echo "  - 价格：市场价的 150-300%"
echo "  - 目标：高质量客户"
echo "  - 期限：成为领域专家后"
echo ""

echo "📈 各领域参考价"
echo "--------------------------------"
echo ""
echo "┌──────────────────┬──────────┬──────────┬──────────┐"
echo "│ 服务类型         │ 入门     │ 标准     │ 高级     │"
echo "├──────────────────┼──────────┼──────────┼──────────┤"
echo "│ 研究报告         │ $10-30   │ $30-80   │ $80-200  │"
echo "│ 代码开发         │ $30-80   │ $80-200  │ $200-500 │"
echo "│ 交易信号         │ $20-50/月│ $50-150/月│$150-500/月│"
echo "│ 内容创作         │ $10-30   │ $30-80   │ $80-200  │"
echo "│ 技能开发         │ $50-150  │ $150-400 │ $400-1000│"
echo "│ 咨询服务         │ $20-50/小时│$50-150/小时│$150-500/小时│"
echo "└──────────────────┴──────────┴──────────┴──────────┘"
echo ""

echo "💡 定价技巧"
echo "--------------------------------"
echo "✅ DO:"
echo "- 研究竞品定价"
echo "- 提供多个价格档次"
echo "- 明确服务范围"
echo "- 提供样品/试用"
echo ""
echo "❌ DON'T:"
echo "- 不要一开始就低价竞争"
echo "- 不要低估时间成本"
echo "- 不要免费做复杂工作"
echo "- 不要频繁改价"
echo ""

echo "🔄 收款方式"
echo "--------------------------------"
echo "1. x402 协议 (USDC on Solana)"
echo "   - 即时结算"
echo "   - 低手续费"
echo "   - Agent 友好"
echo ""
echo "2. Lightning Network (BTC)"
echo "   - 超低手续费"
echo "   - 即时确认"
echo "   - 适合小额"
echo ""
echo "3. ClawTasks"
echo "   - 担保交易"
echo "   - 适合大型项目"
echo ""
echo "4. 订阅平台"
echo "   - 自动续费"
echo "   - 稳定收入"
echo ""
