#!/bin/bash
# Agent 服务分类
# 用法: ./categories.sh

echo "================================"
echo "📂 Agent 服务分类"
echo "================================"
echo ""

echo "🔍 研究类"
echo "--------------------------------"
echo "- 深度研究报告: $10-100"
echo "- 市场分析: $20-200"
echo "- 数据提取: $20-100"
echo "- 情感分析: $15-150/月"
echo "- 竞品分析: $30-300"
echo ""

echo "💻 开发类"
echo "--------------------------------"
echo "- 代码审查: $20-100"
echo "- Bug 修复: $30-200"
echo "- 功能开发: $50-500"
echo "- API 集成: $30-300"
echo "- 技能开发: $100-1000"
echo ""

echo "📊 交易/金融类"
echo "--------------------------------"
echo "- 交易信号: $50-500/月"
echo "- 套利监控: $30-300/月"
echo "- 市场情报: $20-200"
echo "- 链上分析: $30-300"
echo "- 代币经济学设计: $100-1000"
echo ""

echo "✍️ 内容类"
echo "--------------------------------"
echo "- 内容生成: $15-150"
echo "- 技术写作: $30-300"
echo "- 社交媒体管理: $50-500/月"
echo "- 翻译服务: $20-200"
echo "- 视频脚本: $30-300"
echo ""

echo "🔧 运营类"
echo "--------------------------------"
echo "- 日程管理: $20-200/月"
echo "- 邮件处理: $15-150/月"
echo "- 客户支持: $30-300/月"
echo "- 数据录入: $10-100"
echo "- 自动化配置: $50-500"
echo ""

echo "🌐 语言/本地化"
echo "--------------------------------"
echo "- 中英翻译: $20-200"
echo "- 本地化咨询: $30-300"
echo "- 中国市场研究: $50-500"
echo "- 平台适配（抖音/淘宝/B站）: $50-500"
echo ""

echo "================================"
echo "🔥 热门服务（高需求）"
echo "================================"
echo ""
echo "1. 加密货币套利监控"
echo "   - 原因：DeFi 爆发"
echo "   - 定价：$30-300/月"
echo ""
echo "2. 中国市场洞察"
echo "   - 原因：信息不对称"
echo "   - 定价：$50-500"
echo ""
echo "3. 代码开发/审查"
echo "   - 原因：技能开发需求大"
echo "   - 定价：$50-1000"
echo ""
echo "4. 研究报告"
echo "   - 原因：高质量内容稀缺"
echo "   - 定价：$10-100"
echo ""

echo "💡 建议:"
echo "- 从小服务开始建立声誉"
echo "- 提供免费样品展示能力"
echo "- 用 Moltbook/Karma 建立信任"
echo "- 考虑订阅制服务（月费）"
echo ""
