# Agent Registry v2.0.1 (Security Hardening)

Release date: 2026-02-15

## Why this release

The previously shared VirusTotal report (`11157fdde1fb132db6ea21c53fd6515130bb68e0fa64a02ef7e109d40f731e3d`) corresponds to an older `skill.zip` snapshot and referenced outdated behavior (Python-based migration/install flow).  
Version `2.0.1` ships hardened JavaScript/Bun implementation changes and updated docs/tests.

## Security and trust updates

1. Path confinement for agent loading:
   - `bin/get.js` now resolves agent paths through a strict validator.
   - Registry entries cannot escape the skill `agents/` directory.
2. Non-destructive migration default:
   - `bin/init.js` now copies by default.
   - `--move` is explicit opt-in for destructive migration.
3. Installer network behavior tightened:
   - `install.sh` no longer installs dependencies by default.
   - Optional dependency install requires `--install-deps`.
4. Telemetry changed to opt-in:
   - No telemetry requests are sent unless `AGENT_REGISTRY_TELEMETRY=1`.

## Version updates

- `package.json`: `2.0.1`
- `package-lock.json`: `2.0.1`
- `SKILL.md`: `2.0.1`
- `lib/telemetry.js`: `2.0.1`

## Validation

- Test suite result: `107 passed, 0 failed`
- Command: `bun test`

## Release artifact and hash

Build artifact from tracked files:

```bash
./bin/build-release-artifact.sh
```

Example output:

- Artifact: `/tmp/agent-registry-v2.0.1.zip`
- SHA256: `aa77d4384c87f8604c6b2af4a0fc42d70bab07c0a3a22f35ace7c30645381a73`

## Publishing checklist

1. Commit and push `v2.0.1` changes.
2. Tag release: `git tag v2.0.1 && git push origin v2.0.1`
3. Build artifact: `./bin/build-release-artifact.sh`
4. Upload `/tmp/agent-registry-v2.0.1.zip` to VirusTotal and ClawHub.
5. Add the new SHA-256 and report URLs to the GitHub release notes.
