---
name: agent-passport
version: 2.4.0
description: "OAuth for the agentic era. Consent-gating for ALL sensitive agent actions. 75+ data-driven threat definitions with auto-updates (like antivirus signatures). Includes Skill Scanner, Injection Shield, SSRF Shield, Path Traversal Guard, spending caps, rate limits, allowlists, TTL expiry, audit trails, and KYA metadata. Pro tier adds real-time threat definition updates every 6 hours."
metadata: {"openclaw":{"requires":{"bins":["jq","bc","xxd","head","date","mkdir"],"env":["AGENT_PASSPORT_LEDGER_DIR"]}}}
user-invocable: true
---

# Agent Passport (OpenClaw)

## 30-Second Setup

```bash
# Initialize and register your agent
./mandate-ledger.sh init agent:my-assistant "Your Name" "personal assistant" "openclaw"

# Grant dev tool access (git, npm, docker, etc.)
./mandate-ledger.sh create-from-template dev-tools

# That's it! The agent will now check permissions before sensitive actions.
```

> **Templates available:** `dev-tools` · `email-team <domain>` · `file-ops <path>` · `web-research` · `safe-browsing` · `coding` · `email-assistant` · `read-only` · `full-auto`
> Run `./mandate-ledger.sh templates` to see all options.

---

## ⚡ Agent Behavioral Contract

**If you are an agent reading this skill, these are your rules. Follow them.**

### When to Check

Before performing ANY of these actions, you MUST call `check-action` first:

| Action | Category | Example target |
|--------|----------|----------------|
| Running a shell command | `system` | `"git pull"`, `"npm install"` |
| Sending a message/email | `communication` | `"bob@company.com"` |
| Writing/deleting a file | `data` | `"/path/to/file.txt"` |
| Making an API call with side effects | `external_api` | `"api.github.com"` |
| Spending money | `financial` | `"merchant_amazon"` with amount |
| Acting publicly as the user | `identity` | `"twitter_post"` |

**You do NOT need to check:** reading files, web searches, internal reasoning, or anything with no side effects.

### How to Check

```bash
SCRIPT_DIR="$HOME/.openclaw/skills/agent-passport/scripts"

result=$($SCRIPT_DIR/mandate-ledger.sh check-action "<your_agent_id>" "<category>" "<target>" [amount])
```

Parse the result:
- `authorized: true` → proceed, then log the action afterward
- `authorized: false` → **STOP. Ask the user.**
- If response includes `kill_switch: true` or reason `Kill switch engaged` → **STOP immediately** and ask user to run `mandate-ledger.sh unlock`

### The Flow

```
1. You want to do something sensitive
2. Call check-action
3. IF authorized:
   a. Do the thing
   b. Log it: mandate-ledger.sh log-action <mandate_id> <amount> "<description>"
4. IF denied:
   a. Tell the user what you want to do and why
   b. Suggest a mandate (show scope, duration, constraints)
   c. Wait for approval
   d. If approved, create the mandate, then proceed
```

### How to Ask for Permission

When denied, present it clearly and concisely:

```
I need to [ACTION] but don't have a mandate for it.

📋 [CATEGORY]: [what you want to do]
🎯 Target: [specific target]
⏰ Suggested duration: [reasonable TTL]

Want me to set this up? I can also create a broader mandate if you'd
prefer (e.g., all emails to @company.com for 30 days).
```

**DO NOT:**
- Bypass the check and do it anyway
- Ask repeatedly for the same thing if denied
- Create mandates yourself without user approval
- Pretend you checked when you didn't

**DO:**
- Suggest templates when appropriate ("Want me to set up `dev-tools`?")
- Batch similar requests ("I'll need to run several git commands — want a dev-tools mandate?")
- Log every action after completion
- Mention remaining limits when relevant ("3/20 daily emails used")

### First-Time Setup

If `check-action` returns `"hint": "templates"`, the ledger is empty. Guide the user:

```
Agent Passport isn't set up yet. It takes 30 seconds:

  mandate-ledger.sh init agent:me "Your Name" "assistant" "openclaw"
  mandate-ledger.sh create-from-template dev-tools

Want me to run this for you?
```

### Logging Actions

After every authorized action, log it:

```bash
$SCRIPT_DIR/mandate-ledger.sh log-action "<mandate_id>" <amount> "<description>"
```

- For financial: amount = dollars spent
- For everything else: amount = 1
- Description should be human-readable: "Sent email to bob@company.com re: Q1 report"

### Kill Switch Behavior

If the user engages the kill switch, all operations are frozen until unlocked.

```bash
./mandate-ledger.sh kill "user requested freeze"
./mandate-ledger.sh unlock
```

Agent behavior when kill switch is active:
- Do not attempt sensitive actions
- Do not retry `check-action` in a loop
- Tell user operations are blocked and request explicit `unlock`

---

## Overview

Agent Passport provides a consent layer for agent autonomy. Instead of all-or-nothing permissions, users grant **mandates** with specific constraints:

```
"I authorize this agent to [ACTION] with [CONSTRAINTS] until [EXPIRY]"
```

This isn't just about purchases — it's consent-gating for **all sensitive actions**.

## Action Categories

| Category | Examples | Typical Constraints |
|----------|----------|---------------------|
| `financial` | Purchases, transfers, subscriptions | Spending cap, merchant allowlist |
| `communication` | Emails, messages, tweets, posts | Recipient allowlist, rate limit |
| `data` | Delete files, edit docs, DB writes | Path allowlist, require backup |
| `system` | Shell commands, installs, configs | Command allowlist, no sudo |
| `external_api` | Third-party API calls | Service allowlist, rate limit |
| `identity` | Public actions "as" the user | Human review required |

## Wildcard Patterns

Allowlists and deny lists support three wildcard styles:

| Pattern | Matches | Example |
|---------|---------|---------|
| `prefix *` | Anything starting with prefix | `git *` → `git pull`, `git status` |
| `*.suffix` | Anything ending with suffix | `*.env` → `config.env`, `.env` |
| `*middle*` | Anything containing middle | `*/.git/*` → `repo/.git/config` |
| `*@domain` | Email domain match | `*@company.com` → `bob@company.com` |
| `exact` | Exact match only | `api.github.com` |

## Modes

- **Local mode** (default): Mandates stored in `~/.openclaw/agent-passport/`. Free tier is fully offline. Pro tier makes periodic API calls to `api.agentpassportai.com` for license validation and threat definition updates.
- **Preview mode:** No storage, no network. Generates validated payloads and curl templates.
- **Live mode (roadmap):** Future connection to Agent Bridge backend for multi-agent sync and compliance. Not yet implemented.

## Quick Start Commands

```bash
# Initialize with identity
./mandate-ledger.sh init <agent_id> <principal> [scope] [provider]

# Templates (auto-detects agent if registered)
./mandate-ledger.sh templates
./mandate-ledger.sh create-from-template dev-tools
./mandate-ledger.sh create-from-template email-team <domain>
./mandate-ledger.sh create-from-template file-ops <path>
./mandate-ledger.sh create-from-template web-research
./mandate-ledger.sh create-from-template safe-browsing
./mandate-ledger.sh create-from-template coding
./mandate-ledger.sh create-from-template email-assistant
./mandate-ledger.sh create-from-template read-only
./mandate-ledger.sh create-from-template full-auto

# Quick create (human-friendly durations: 7d, 24h, 30m)
./mandate-ledger.sh create-quick <type> <agent_id> <allowlist_csv> <duration> [amount_cap]

# Check & log
./mandate-ledger.sh check-action <agent> <type> <target> [amount]
./mandate-ledger.sh log-action <mandate_id> <amount> "<description>"

# Audit
./mandate-ledger.sh audit [limit]
./mandate-ledger.sh summary

# Threat definitions
./mandate-ledger.sh init-definitions
./mandate-ledger.sh update-definitions
./mandate-ledger.sh definitions-status
```

## Commands Reference

### Quick Start
```bash
init [agent_id] [principal] [scope] [provider]
                           # Initialize ledger, optionally register agent
templates                  # List available templates
create-from-template <t>   # Create mandate from template
  [agent_id] [args...]
create-quick <type>        # Create with positional args
  <agent_id> <allowlist>
  <duration> [amount_cap]
```

### Mandate Lifecycle
```bash
create <json>              # Create mandate (include action_type)
create-with-kya <json>     # Create with auto-attached agent KYA
get <mandate_id>           # Get mandate by ID
list [filter]              # List mandates (all|active|revoked|<action_type>)
revoke <mandate_id> [why]  # Revoke a mandate
```

### Authorization
```bash
check-action <agent> <type> <target> [amount]
                           # Check if action is authorized
log-action <mandate_id> <amount> [description]
                           # Log action against mandate
kill <reason>               # Engage kill switch and freeze execution
unlock                      # Disengage kill switch
```

### Audit & Reporting
```bash
audit [limit]              # Show recent audit entries
audit-mandate <id>         # Show audit for specific mandate
audit-summary [since]      # Summary by action type
summary                    # Show overall ledger stats
export                     # Export full ledger as JSON
```

### Threat Definitions
```bash
init-definitions           # Write bundled threat-definitions.json to LEDGER_DIR
update-definitions         # Refresh definitions (Pro: API pull, Free: bundled copy)
  [--force] [--offline]
definitions-status         # Show version, pattern counts, and last update
```

### KYA (Know Your Agent)
```bash
kya-register <agent_id> <principal> <scope> [provider]
kya-get <agent_id>
kya-list
kya-revoke <agent_id> [why]
```

## Mandate Structure

```json
{
  "mandate_id": "mandate_1770412575_3039e369",
  "action_type": "communication",
  "agent_id": "agent:my-assistant",
  "scope": {
    "allowlist": ["*@mycompany.com", "bob@partner.com"],
    "deny": ["*@competitor.com"],
    "rate_limit": "20/day",
    "kya": { "status": "verified", "verified_principal": "Mark" }
  },
  "amount_cap": null,
  "ttl": "2026-02-13T00:00:00Z",
  "status": "active",
  "usage": { "count": 5, "total_amount": 0 },
  "created_at": "2026-02-06T22:00:00Z"
}
```

## Agent Bridge (Future Roadmap)

> **Note:** Free tier is fully local with no network calls. Pro tier (`AGENT_PASSPORT_LICENSE_KEY` set) makes periodic HTTPS calls to `api.agentpassportai.com` for license validation and threat definition updates. No usage data or scan results are transmitted. Agent Bridge is a planned future service.

Local mode handles single-user, single-agent scenarios. A future Agent Bridge service would add:

- **Multi-agent coordination** — prevent overlapping mandates
- **Cross-device sync** — same mandates everywhere
- **Organization policies** — IT guardrails, user customization within
- **Compliance reporting** — audit exports for regulatory needs
- **Merchant/service registry** — verified vendors, trust scores

Export local ledger anytime: `./mandate-ledger.sh export > backup.json`

## Configuration (OpenClaw)

```json
{
  "skills": {
    "entries": {
      "agent-passport": {
        "env": {
          "AGENT_PASSPORT_LOCAL_LEDGER": "true"
        },
        "config": {
          "default_currency": "USD",
          "default_ttl_minutes": 60,
          "confirm_threshold_amount": 50
        }
      }
    }
  }
}
```

## Storage

All data stored locally in `~/.openclaw/agent-passport/`:
- `mandates.json` — mandate ledger
- `agents.json` — KYA registry
- `audit.json` — action audit trail
- `threat-definitions.json` — active threat pattern definitions
- `threat-definitions.bak` — previous definitions backup
- `.threat-meta.json` — last update/version/source metadata

## Safety

- Never leak secrets into prompts, logs, or outputs
- Mandates constrain actions, but don't prevent all misuse
- Audit trail provides accountability, not prevention
- Use KYA to verify agent identity before granting broad mandates
