---
name: agent-memory-templates
version: 1.0.0
description: "Production-tested memory templates for AI agents. Includes SOUL.md personality templates, memory checkpoint patterns, observational memory configs, and 100 power prompts. From the creators of ClawVault."
metadata:
  openclaw:
    emoji: "🧠"
---

# Agent Memory Templates

Production-tested templates for building AI agents with memory.

## What's Included

### Free Templates
- Memory checkpoint template
- Session handoff template
- Context death recovery pattern
- Daily note generator
- Decision logger format

### Premium Content
For the complete set of 100 prompts, 12 personality templates, and the full memory architecture playbook:

- **100 Power Prompts ($9)**: https://whop.com/checkout/plan_W7BJwJmYlXsjF
- **Complete Bundle ($47)**: https://whop.com/checkout/plan_umnonnlgKVjvo
- **Free Cheat Sheet**: https://cheatsheet.versatlygroup.com
- **Free Prompt Preview**: https://prompts.versatlygroup.com

## Quick Start

```bash
# Use the memory checkpoint pattern
clawvault checkpoint --working-on "your task" --focus "key details"

# Use the session handoff
clawvault sleep "what you accomplished" --next "what's next"

# Recovery on wake
clawvault wake
```

## Built by Versatly
https://store.versatlygroup.com | https://clawvault.dev
