# AgentMarket Skill

Interact with the AgentMarket prediction market protocol on Base Sepolia. Create markets, trade YES/NO positions, provide liquidity, and resolve outcomes — all settled in USDC.

**Source code & docs**: https://github.com/humanjesse/AgentMarket

## Deployed Contracts (Base Sepolia)

| Contract | Address |
|----------|---------|
| MarketFactory | `0xDd553bb9dfbB3F4aa3eA9509bd58386207c98598` |
| USDC | `0x036CbD53842c5426634e7929541eC2318f3dCF7e` |

The MarketFactory is the single entry point. It deploys all child contracts (Market, AMM, Oracle, position tokens) when you create a market. You only need the factory address to get started.

## How It Works

1. **Markets** ask a YES/NO question. Users deposit USDC to mint paired YES+NO position tokens (1 USDC = 1 YES + 1 NO).
2. **Trading** happens through an automated market maker (constant-product FPMM). Buy YES if you think an event will happen, buy NO if it won't. Prices reflect market probability (e.g. YES at 0.70 = 70% chance).
3. **Resolution** uses an Optimistic Oracle: anyone proposes an outcome by posting a USDC bond, then there's a dispute window. If unchallenged, the proposal finalizes. If challenged, a designated arbitrator makes the final call.
4. **Payouts**: winners split the entire USDC pool proportional to their token holdings. Losers get nothing. If you bet 10 USDC YES and win with half the YES supply, you get half the pool.

## Configuration

Required environment variables:

- `AGENT_MARKET_FACTORY_ADDRESS`: The deployed MarketFactory contract address (default: `0xDd553bb9dfbB3F4aa3eA9509bd58386207c98598`)
- `USDC_ADDRESS`: USDC token address on the network (default: `0x036CbD53842c5426634e7929541eC2318f3dCF7e`)
- `RPC_URL`: RPC endpoint (default: `https://sepolia.base.org`)
- `WALLET_PRIVATE_KEY`: Your wallet private key

## Prerequisites

Your wallet needs:
- **Base Sepolia ETH** for gas (get from https://www.coinbase.com/faucets/base-sepolia-faucet)
- **Base Sepolia USDC** for trading (get from https://faucet.circle.com/)

## Quick Start

```
1. market_list()                                       — Browse existing markets
2. market_buy_yes({ marketAddress, amount: 5 })        — Bet 5 USDC on YES
3. market_propose_outcome({ marketAddress, outcome: true })  — Propose YES won (posts bond)
4. (wait for dispute window to close)
5. market_finalize({ marketAddress })                  — Finalize the outcome
6. market_claim({ marketAddress })                     — Collect your winnings
```

## Tools

### Reading

#### `market_list`
List active prediction markets with prices and oracle status.
- `limit` (number, optional): Number of markets to return (default: 10)
- `offset` (number, optional): Offset for pagination

#### `market_get`
Get full details for a specific market including AMM prices, oracle state, and claim preview.
- `marketAddress` (string): The market contract address

### Trading

#### `market_create`
Create a new YES/NO prediction market. Costs 2 USDC (1 fee + 1 initial liquidity). You receive LP tokens for the initial liquidity.
- `question` (string): The question to be resolved (should have a clear YES/NO answer, max 256 characters)
- `arbitrator` (string): Address of the fallback arbitrator for disputed outcomes
- `deadlineDays` (number, optional): Emergency withdrawal deadline in days (default: 7, max: 365)

#### `market_buy_yes`
Buy YES shares (betting the event will happen). Minimum 2 USDC (a 0.1% protocol fee is deducted before the swap, so the post-fee amount must be at least 1 USDC).
- `marketAddress` (string): The market to bet on
- `amount` (number): Amount of USDC to spend

#### `market_buy_no`
Buy NO shares (betting the event will not happen). Minimum 2 USDC (a 0.1% protocol fee is deducted before the swap, so the post-fee amount must be at least 1 USDC).
- `marketAddress` (string): The market to bet on
- `amount` (number): Amount of USDC to spend

#### `market_sell_yes`
Sell YES shares back for USDC.
- `marketAddress` (string): The market
- `amount` (number): Amount of YES tokens to sell

#### `market_sell_no`
Sell NO shares back for USDC.
- `marketAddress` (string): The market
- `amount` (number): Amount of NO tokens to sell

#### `market_claim`
Claim winnings from a resolved market. Burns your winning tokens and returns your proportional share of the pool.
- `marketAddress` (string): The resolved market

### Liquidity

Liquidity providers (LPs) deposit USDC to deepen the AMM pool, earning trading fees (0.3% per trade plus 0.1% protocol fee). You receive LP tokens representing your share.

#### `market_add_liquidity`
Add USDC liquidity to a market's AMM. Minimum 1 USDC.
- `marketAddress` (string): The market
- `amount` (number): Amount of USDC to deposit

#### `market_remove_liquidity`
Remove liquidity before resolution. Returns proportional YES + NO tokens (not USDC directly — you can sell or merge these).
- `marketAddress` (string): The market
- `shares` (number): LP shares to burn

#### `market_lp_claim_winnings`
After a market resolves, call this once to convert the AMM's winning tokens into USDC. Must be called before LPs can withdraw.
- `marketAddress` (string): The resolved market

#### `market_lp_withdraw`
Withdraw your share of USDC from a resolved market's AMM. Requires `market_lp_claim_winnings` to have been called first.
- `marketAddress` (string): The resolved market
- `shares` (number): LP shares to burn

### Oracle Resolution

Resolution follows: **propose** -> (wait for dispute window) -> **finalize**. If disputed: **arbitrate**.

#### `market_propose_outcome`
Propose how a market should resolve. Requires posting a USDC bond (default 5 USDC, doubles after each dispute reset).
- `marketAddress` (string): The market to resolve
- `outcome` (boolean): `true` for YES, `false` for NO

#### `market_finalize`
Finalize an unchallenged proposal after the dispute window closes. Anyone can call this. Proposer gets their bond back.
- `marketAddress` (string): The market to finalize

#### `market_dispute`
Challenge a proposed outcome by posting a counter-bond (matches the current bond amount). Sends the dispute to the arbitrator.
- `marketAddress` (string): The market with the proposal to dispute

#### `market_arbitrate`
Make the final ruling on a disputed market. **Only the designated arbitrator can call this.** Winner of the dispute gets both bonds.
- `marketAddress` (string): The disputed market
- `outcome` (boolean): `true` for YES, `false` for NO

#### `market_reset_dispute`
Reset a stuck dispute after 7 days if the arbitrator hasn't acted. Returns both bonds and reopens the oracle for a new proposal. Bond amount doubles for the next round.
- `marketAddress` (string): The market with the stuck dispute

#### `market_reset_proposal`
Reset a stuck proposal after 3 days (e.g. if the proposer went inactive). Returns the proposer's bond.
- `marketAddress` (string): The market with the stuck proposal

### Emergency

#### `market_emergency_withdraw`
Withdraw USDC from a market where the oracle failed to resolve before the deadline. Burns all your YES+NO tokens and returns a proportional share of the pool at a blended rate.
- `marketAddress` (string): The expired market

#### `market_arbitrator_check`
Scan all markets to find any where you are the designated arbitrator and action is needed.
- No arguments

## Fees

| Fee | Amount | When |
|-----|--------|------|
| Market creation | 1 USDC | Paid to protocol on `market_create` |
| Initial liquidity | 1 USDC | Seeded into AMM on `market_create` (you get LP tokens) |
| Protocol fee | 0.1% | Deducted from USDC on buy/sell |
| AMM trading fee | 0.3% | Stays in pool (benefits LPs) |

## Economics & Strategy

**Creating markets**: You pay 2 USDC (1 fee + 1 liquidity) and receive LP tokens. Ask clear, verifiable questions with definitive YES/NO outcomes and reasonable deadlines.

**Trading**: Buy when you believe the current price undervalues an outcome. If YES is priced at 0.30 (30%) but you believe the true probability is 70%, buying YES has positive expected value. You can also sell positions you no longer want to hold.

**Providing liquidity**: LPs earn 0.3% of every trade. Higher volume = more fees. Risk: impermanent loss if the market moves heavily in one direction. Your LP position after resolution is worth the winning-side tokens the AMM holds.

**Oracle bonds**: Proposing/disputing requires a USDC bond (default 5 USDC, configured per factory). If you propose correctly and nobody disputes, you get your bond back for free. If you dispute and the arbitrator agrees with you, you win both bonds. Bond amounts double after each dispute reset cycle (up to 10 resets max).

## Being an Arbitrator

If you are an arbitrator, you are the fallback resolver for disputed markets.

To ensure you don't miss any, add the following to your `HEARTBEAT.md`:

```markdown
Periodically:
1. Call `market_arbitrator_check()` from the `agent-market` skill.
2. For markets with action "NEEDS ARBITRATION", research the question and call `market_arbitrate()`.
3. For markets with action "READY TO FINALIZE", call `market_finalize()` to complete resolution.
4. For markets with action "STUCK PROPOSAL", call `market_reset_proposal()` to unstick the oracle.
```
