---
name: agent-hq
description: Deploy the Agent HQ mission-control stack (Express + React + Telegram notifier / Jarvis summary) so other Clawdbot teams can spin up the same board, high-priority watcher, and alert automation. Includes setup, telemetry, and automation hooks.
---

# Agent HQ Installation

## Summary

- **Backend + frontend**: Express API with SQLite board + Vite/React UI served from `frontend-react/dist`.
- **Automation pieces**: Jarvis summary (`scripts/jarvis-connector.js`), Telegram notifier (`scripts/notify-jarvis-telegram.js` + cron), plus a high-priority watcher inside `backend/server.js`.
- **Data**: `data/board.json` seeds missions/agents/cards; the board persists in `data/mission.db`.
- **Notifications**: `config/telegram.json` (or `AGENT_HQ_TELEGRAM_*` env vars) lets you send alerts to Telegram.

## Setup steps

1. Clone the repo and install deps:
   ```bash
   git clone https://github.com/thibautrey/agent-hq.git
   cd agent-hq
   npm install
   npm --prefix frontend-react install
   ```
2. Edit `config/telegram.json` with your `botToken`/`chatId` (or set `AGENT_HQ_TELEGRAM_TOKEN`/`AGENT_HQ_TELEGRAM_CHAT_ID`). Keep this file secret.
3. Build the UI and start the server:
   ```bash
   npm --prefix frontend-react run build
   npm run start:agent-hq
   ```
   The UI is served on `/` and the API lives under `/api` (default port 4000).
4. Configure cron jobs (Heartbeats + Telegram):
   - Jarvis summary: `node scripts/jarvis-connector.js` or `scripts/notify-jarvis-telegram.js --force` as needed.
   - Telegram notifier cron (see `run-telegram-notifier.sh`).
5. Use the UI to create cards or `POST /api/cards`/`/api/cards/quick` to keep Jarvis busy.

## Runtime commands

- **View board**: `curl http://localhost:4000/api/board`
- **Trigger Telegram alert**: `curl -X POST http://localhost:4000/api/notify-telegram`
- **Quick card**: `curl -X POST http://localhost:4000/api/cards/quick -H "Content-Type: application/json" -d '{"text":"Design review needed"}'`
- **Jarvis summary**: `node scripts/jarvis-connector.js`

## Tips

- Drop cards directly into `data/board.json` before first run for a seeded mission.
- `high_priority_jobs` table in SQLite prevents duplicate Telegram alerts.
- `AGENT_HQ_API_TOKEN` protects mutating endpoints for scripted integrations.

## Release notes

- **2026-02-09** – Mission-control stack created, README translated to English, changelog added, and the Clawdhub installer skill `agent-hq@1.0.0` published (now mirrored with this manifest).

Enjoy running your own Mission Control.
