"""
Project Name — Official Module Registry
========================================

These are the VALIDATED, ESTABLISHED functions for this project.
Any new script MUST import from here. Do NOT reimplement.

Usage:
    from project_name import function_a, function_b

Instructions:
    1. Replace 'project_name' with your actual project/package name
    2. Replace the example imports below with your real modules and functions
    3. Update the module reference section
    4. New scripts must import from this registry, not reimplement
"""

# === Core Module (your_core_module.py) ===
# Uncomment and edit these imports to match your project:
#
# from .your_core_module import (
#     validate_data,        # Validate input data
#     process_data,         # Main data processing pipeline
#     generate_report,      # Generate output report
# )

# === Utility Module (utils.py) ===
# from .utils import (
#     fetch_data,           # Fetch data from external sources
#     format_output,        # Format output for display
# )

# === What each module does (for reference) ===
# your_core_module.py  — Core logic: validation, processing, reporting
# utils.py             — Shared utilities: data fetching, formatting
# config.py            — Configuration management

# === RULES ===
# 1. Functions listed above are the ONLY approved implementations
# 2. New scripts that need these capabilities MUST import, not reimplement
# 3. If you need new functionality, EXTEND existing modules first
# 4. Don't create parallel versions of existing validated functions
