#!/bin/bash
# agent-deploy: List all configured agents
CONFIG="$HOME/.openclaw/openclaw.json"

python3 << 'PYEOF'
import json

with open("/root/.openclaw/openclaw.json") as f:
    config = json.load(f)

agents = config.get("agents", {}).get("list", [])
bindings = config.get("bindings", [])
accounts = config.get("channels", {}).get("telegram", {}).get("accounts", {})

print("?? Configured Agents\n")
print(f"{'ID':<12} {'Workspace':<40} {'Tools Deny':<15} {'Telegram Account':<15} {'Bot Token'}")
print("-" * 110)

for a in agents:
    aid = a.get("id", "?")
    ws = a.get("workspace", "?")
    deny = ",".join(a.get("tools", {}).get("deny", [])) or "none"
    
    # Find binding
    tg_acct = "none"
    for b in bindings:
        if b.get("agentId") == aid and b.get("match", {}).get("channel") == "telegram":
            tg_acct = b["match"].get("accountId", "?")
    
    # Find token
    token = accounts.get(tg_acct, {}).get("botToken", "N/A")
    token_short = token[:10] + "..." if len(token) > 10 else token
    
    print(f"{aid:<12} {ws:<40} {deny:<15} {tg_acct:<15} {token_short}")

print(f"\nTotal: {len(agents)} agents")
PYEOF
