---
name: agent-deploy
description: Deploy a new isolated OpenClaw agent with its own Telegram bot, workspace, and session storage. Use when user asks to create a new agent, add a new bot, or set up multi-agent routing. Handles workspace creation, config modification, binding setup, and state isolation automatically.
---

# Agent Deploy & Isolation Skill

Create and manage isolated OpenClaw agents with per-bot Telegram bindings.

## Usage

Tell me to deploy a new agent with a description like:

> ??????????Agent?????? `research`?????? Telegram Bot Token `123456:ABC...`

Or use the slash command:

```
/agent-deploy <agentId> <telegramBotToken> [description]
```

## What This Skill Does

### 1. Pre-flight Checks
- Validate the bot token format (`digits:alphanumeric`)
- Check if the agentId already exists
- Verify no config conflicts

### 2. Create Isolated Workspace
```
~/.openclaw/workspace-<agentId>/
????? SOUL.md        # Agent persona (from template or user input)
????? AGENTS.md      # Agent configuration guide
????? README.md      # Usage documentation
????? memory/        # Agent-specific memory
????? output/        # Agent-specific output
????? skills/        # Per-agent skills (optional)
```

### 3. Update Gateway Config (`openclaw.json`)

**IMPORTANT**: Always use the safe update script. NEVER edit `openclaw.json` directly with file edit tools.

Run the deploy script:
```bash
bash {baseDir}/scripts/deploy.sh <agentId> <botToken> [workspace_path]
```

The script will:
1. **Backup** `openclaw.json` to `openclaw.json.pre-<agentId>`
2. **Add** the agent to `agents.list` with isolation settings:
   - Independent workspace path
   - `tools.deny: ["gateway"]` (prevents config corruption)
   - `sandbox.mode: "off"` (configurable)
3. **Add** a binding: `agentId` ??Telegram `accountId`
4. **Add** the Telegram account with the bot token
5. **Validate** the JSON before writing

### 4. Restart Gateway
```bash
systemctl --user restart openclaw-gateway
```

### 5. Verify
```bash
journalctl --user -u openclaw-gateway --no-pager -n 15
```
Look for: `[telegram] [<agentId>] starting provider`

## State Isolation Architecture

Each agent gets **complete isolation**:

| Layer | Path | Isolated? |
|-------|------|-----------|
| Workspace | `~/.openclaw/workspace-<agentId>/` | ??Independent |
| Sessions | `~/.openclaw/agents/<agentId>/sessions/` | ??Auto-created |
| Agent State | `~/.openclaw/agents/<agentId>/agent/` | ??Auto-created |
| Tools | `tools.deny: ["gateway"]` | ??Cannot modify core config |
| Telegram | `channels.telegram.accounts.<agentId>` | ??Own bot token |

## Safety Rules

> ??? **CRITICAL**: Do NOT use file edit tools to modify `openclaw.json`. Always use the deploy script which includes JSON validation and automatic backup.

> ??? **CRITICAL**: Do NOT change model mid-task when performing config operations. Complete the current task first.

## Removing an Agent

```bash
bash {baseDir}/scripts/remove.sh <agentId>
```

## Listing Agents

```bash
bash {baseDir}/scripts/list.sh
```

## Reference

- [Multi-Agent Routing](https://docs.openclaw.ai/concepts/multi-agent)
- [Telegram bots per agent](https://docs.openclaw.ai/concepts/multi-agent#telegram-bots-per-agent)
- [Per-Agent Sandbox](https://docs.openclaw.ai/concepts/multi-agent#per-agent-sandbox-and-tool-configuration)
