# Code Conventions

<!-- This file is loaded only when a task involves writing or modifying code. -->
<!-- Keep entries specific and actionable. Prefer file:line pointers over code snippets. -->

## Naming

- [e.g., camelCase for variables, PascalCase for components, kebab-case for files]

## File Structure

- [e.g., One component per file. Co-locate tests with source files.]

## Patterns to Follow

- [e.g., Use named exports, not default exports]
- [e.g., Error handling: use Result types, not try/catch]

## Patterns to Avoid

- [e.g., No `any` types in TypeScript]
- [e.g., No inline styles — use Tailwind classes]

## Examples

<!-- Point to existing code rather than pasting snippets. Code changes; pointers are cheaper to maintain. -->

- Good component pattern: see `src/components/Button.tsx`
- Good API route pattern: see `src/api/users.ts`
