# Architecture

<!-- This file is loaded only when a task involves design decisions or cross-cutting changes. -->

## System Overview

- [e.g., Monolithic Next.js app with API routes. PostgreSQL via Prisma. Auth via NextAuth.]

## Data Flow

- [e.g., Client → API route → Prisma → PostgreSQL. No direct DB access from components.]

## Key Decisions

- [e.g., We use server components by default. Client components only when interactivity is required.]
- [e.g., State management: Zustand for client state. No Redux.]

## Boundaries

- [e.g., Never modify `src/generated/` — these are auto-generated by Prisma.]
- [e.g., All env vars go through `src/config.ts` — never read `process.env` directly.]

## External Dependencies

- [e.g., Stripe for payments — webhook handler at `src/api/webhooks/stripe.ts`]
- [e.g., Cloudinary for images — helper at `src/lib/cloudinary.ts`]
