---
name: agent-content-pipeline
description: Safe content workflow (drafts/reviewed/revised/approved/posted) with human-in-the-loop approval, plus CLI to list/move/review and post to LinkedIn/X. Use when setting up a content pipeline, drafting content, managing review threads, or posting approved content.
---

# Content Pipeline Skill

Safe content automation with human-in-the-loop approval. Draft → Review → Approve → Post.

## Setup

```bash
npm install -g agent-content-pipeline
content init . # Creates folders + global config (in current directory)
```

For cryptographic approval signatures (password-protected):
```bash
content init . --secure
```

This creates:
- `drafts/` — work in progress (one post per file)
- `reviewed/` — human reviewed, awaiting your revision
- `revised/` — you revised, ready for another look
- `approved/` — human-approved, ready to post
- `posted/` — archive after posting
- `templates/` — review and customize before use
- `.content-pipeline/threads/` — feedback thread logs (not posted)

## Your Permissions

✅ **Can do:**
- Write to `drafts/`
- Read all content directories
- Revise drafts based on feedback
- Move revised files to `revised/`
- Run `content list` to see pending content

❌ **Cannot do:**
- Move files to `approved/` (only the human can approve)
- Post content
- Set `status: approved`

## Creating Content

**One post per file.** Each suggestion or draft should be a single post, not a collection.

File naming: `YYYY-MM-DD-<platform>-<slug>.md`

Use frontmatter:

```yaml
---
platform: linkedin    # linkedin | x | reddit (experimental)
title: Optional Title
status: draft
subreddit: programming  # Required for Reddit
---

Your content here.
```

Tell the human: "Draft ready for review: `content review <filename>`"

## The Review Loop

```
drafts/ → reviewed/ → revised/ → approved/ → posted/
              ↑          │
              └──────────┘
               more feedback
```

1. You write draft to `drafts/`
2. Human runs `content review <file>`:
   - **With feedback** → file moves to `reviewed/`, you get notified
   - **No feedback** → human is asked "Approve?" → moves to `approved/`
3. If feedback: you revise and move to `revised/`
4. Human reviews from `revised/`:
   - More feedback → back to `reviewed/`
   - Approve → moves to `approved/`
5. Posting happens manually via `content post`

### After Receiving Feedback

When you get review feedback:
1. Read the file from `reviewed/`
2. Apply the feedback
3. Move the file to `revised/`
4. Confirm what you changed
5. (Optional) Add a note: `content thread <file> --from agent`

## Platform Guidelines

### LinkedIn
- Professional but human
- Idiomatic language (Dutch for NL audiences, don't be stiff)
- 1-3 paragraphs ideal
- End with question or CTA
- 3-5 hashtags at end

### X (Twitter)
- 280 chars per tweet (unless paid account)
- Punchy, direct
- 1-2 hashtags max
- Use threads sparingly
- If Firefox auth fails, you can paste `auth_token` and `ct0` manually

Manual cookie steps:
1) Open x.com and log in
2) Open DevTools → Application/Storage → Cookies → https://x.com
3) Copy `auth_token` and `ct0`

### Reddit (experimental)
- Treat as experimental; API and subreddit rules can change
- Requires `subreddit:` in frontmatter
- Title comes from frontmatter `title:` (or first line if missing)
- Match each subreddit's rules and tone

## Commands Reference

```bash
content list                    # Show drafts and approved
content review <file>           # Review: feedback OR approve
content mv <dest> <file>        # Move file to drafts/reviewed/revised/approved/posted
content edit <file>             # Open in editor ($EDITOR or code)
content post <file>             # Post (prompts for confirmation)
content post <file> --dry-run   # Preview without posting
content thread <file>           # Add a note to the feedback thread
```

## Security Model

The security model separates drafting (AI) from approval/posting (human):

- ✅ Agent drafts content
- ✅ Agent revises based on feedback  
- ❌ Agent cannot approve (human approves via `content review`)
- ❌ Agent cannot post

Posting is handled manually via CLI — never by the agent directly.

### Platform-specific security

| Platform | Auth Storage | Encrypted? | Password Required? |
|----------|--------------|------------|-------------------|
| LinkedIn | Browser profile | ✅ Yes | ✅ Yes |
| X/Twitter | Firefox tokens | ✅ Yes | ✅ Yes |

Both platforms require password to post. Tokens are extracted from Firefox and encrypted locally.
