# ClawHub Daily Skill Check — Cron Template

Example cron message for daily ClawHub browsing:

```
Browse ClawHub's popular and highlighted skills like browsing an app store. Don't limit to specific categories.

Step 1: Fetch popular skills (sorted by stars):
curl -s 'https://clawhub.ai/api/v1/skills?sort=stars&limit=50'

Step 2: Fetch trending/recent skills:
curl -s 'https://clawhub.ai/api/v1/skills?sort=trending&limit=30'
curl -s 'https://clawhub.ai/api/v1/skills?sort=downloads&limit=30'
curl -s 'https://clawhub.ai/api/v1/skills?sort=recent&limit=30'

Step 3: For interesting finds, get full details:
curl -s 'https://clawhub.ai/api/v1/skills/SLUG' | python3 -c "import sys,json; d=json.load(sys.stdin)['skill']; s=d.get('stats',{}); print(f'Stars:{s.get(\"stars\",0)} Downloads:{s.get(\"downloads\",0)} Installs:{s.get(\"installsCurrent\",0)}'); print(d.get('summary',''))"

Step 4: Check what's already installed:
clawhub list

Step 5: Write a digest:
- Top 10 popular skills with stats (mark already installed ones)
- Interesting new or trending skills
- Recommendations with reasons (any category)
- Installed skills with available updates

DO NOT auto-install. List recommendations and let the user decide.
```

## Setup

```bash
openclaw cron add \
  --name "ClawHub Daily Skill Check" \
  --cron "0 10 * * *" \
  --tz "America/Los_Angeles" \
  --session isolated \
  --stagger 2m \
  --message "<paste the message above>"
```
