# Team Coordination

## Team Database

Maintain in ~/agency/config.md:

```markdown
### Team Members

#### [Name]
- Role: [role]
- Skills: [skill1, skill2]
- Availability: [hours/week]
- Rate: [internal cost/hour]
- Current projects: [list]
- Notes: [preferences, timezone, communication style]

### Freelancers

#### [Name]
- Specialty: [what they're best at]
- Rate: [hourly/project]
- Reliability: [1-5 rating based on history]
- Last worked: [date]
- Notes: [turnaround time, quality notes]
```

## Assignment Logic

When project needs resources:

1. Check required skills
2. Check availability in team database
3. Consider:
   - Skill match (who's best at this?)
   - Load balancing (who has capacity?)
   - Client history (have they worked with this client?)
   - Growth opportunity (stretch assignment?)

4. Propose assignment with reasoning

## Briefing Freelancers/Team

Generate clear briefs:

```markdown
# Brief: [Task Name]

## Context
[Project background, client, deadline]

## Deliverable
[Exactly what's needed]

## Specs
- Format: [file types, dimensions]
- Style: [references, brand guidelines]
- Quantity: [number of items/variations]

## Timeline
- Draft due: [date]
- Final due: [date]

## Reference Materials
[Links or files]

## Don'ts
[Things to avoid specifically]

## Questions?
[Who to ask, how to reach]
```

## Quality Control

Before accepting team/freelancer work:
- Check against brief requirements
- Verify quality meets agency standards
- Note any issues for feedback

If work doesn't meet standards:
- Specific feedback on what needs fixing
- Clear deadline for revision
- Track patterns (repeated issues = don't use again)

## Capacity Planning

Weekly capacity check:
- Sum committed hours by person
- Flag overallocation (>100% capacity)
- Identify underutilization
- Plan ahead for known upcoming projects

When selling new work:
- Check team capacity for proposed timeline
- If full, either extend timeline or plan to hire/outsource

## Communication with Team

**Project kickoff:**
- Share full context (not just task)
- Explain how their piece fits the whole
- Provide all needed materials upfront

**During project:**
- Check in on blockers
- Provide feedback quickly
- Escalate problems early

**Project close:**
- Thank them specifically
- Share client feedback
- Note what worked/didn't for future
