# Pricing and Proposals

## Rate Card Structure

Maintain in ~/agency/config.md:

```markdown
### Hourly Rates
- Strategy/Senior: $X
- Execution/Mid: $Y
- Junior/Support: $Z

### Project Minimums
- Discovery call: $0 (qualify)
- Small project: $X minimum
- Retainer minimum: $Y/month

### Multipliers
- Rush (<1 week): +50%
- Complex integration: +25%
- Enterprise client: +20%
- Ongoing relationship discount: -10%
```

## Estimation Process

Given a scope:

1. **Break into phases:**
   - Discovery/intake
   - Strategy/planning
   - Execution/production
   - Review/revision rounds
   - Delivery/handoff

2. **Estimate hours per phase:**
   - Be specific: "Homepage design: 6h, inner page template: 3h"
   - Include buffer: 15-20% for scope creep
   - Account for client communication time

3. **Apply multipliers:**
   - Check complexity indicators
   - Check timeline pressure
   - Check client type

4. **Compare to historical:**
   - Search `~/agency/knowledge/` for similar projects
   - Adjust if past estimates were off

## Proposal Structure

Generate PDF with:

```
1. CONTEXT
   - Why they came to us
   - What we heard as the core problem

2. APPROACH
   - How we'll solve it (methodology)
   - Why this approach works

3. DELIVERABLES
   - Specific items they receive
   - Format and quantity

4. TIMELINE
   - Phases with dates
   - Client dependencies/approvals needed

5. INVESTMENT
   - Price (or range)
   - What's included
   - What's not included
   - Payment terms

6. NEXT STEPS
   - How to proceed
   - What we need from them
```

## Pricing Traps

- Don't quote before understanding scope — discovery first
- Don't discount without reducing scope — train clients
- Don't hide revision limits in fine print — state clearly
- Don't underestimate client communication time — it's 20-30% of project
- Don't forget handoff/documentation time

## Version Control

When client requests changes to proposal:
- Save v1 before editing
- Track what changed and why
- Note who requested the change
- If scope reduced, reduce price explicitly

## Historical Comparison

Before finalizing estimate, search:
```
Similar projects in ~/agency/knowledge/:
- What was estimated vs actual
- What caused overruns
- What would we do differently
```
