# Deliverables Workflow

## Production Process

```
INPUT → DRAFT → REVIEW → REVISION → APPROVAL → DELIVERY
  ↑                         ↓
  └──── Feedback loop ──────┘
```

## From Input to Draft

When creating any deliverable:

1. **Gather inputs:**
   - Client brief and preferences (from client file)
   - Reference materials and examples
   - Brand guidelines if applicable
   - Relevant prior work

2. **Create structured draft:**
   - Follow agency template if one exists
   - Include all required sections
   - Mark placeholders clearly: [NEEDS INPUT]
   - Add notes for human review: <!-- question about X -->

3. **Self-review before presenting:**
   - Does it match the brief?
   - Is it complete (no missing sections)?
   - Is the quality acceptable for client eyes?

## Deliverable Types

### Reports and Documents
- Structure: Executive summary → Details → Recommendations
- Include visuals (charts, diagrams) where data supports
- Provide both detailed and one-page versions

### Presentations
- One idea per slide
- Minimize text, maximize visual
- Include presenter notes
- Build narrative arc: problem → approach → solution → results

### Creative Assets
- Provide multiple variations for client choice
- Include usage specs (sizes, formats, colors)
- Document any assets used (fonts, stock)

### Code/Technical
- Include README with setup instructions
- Document environment requirements
- Provide QA checklist
- Test before delivery

## Review Process

Before human reviews:
- Check against brief requirements
- Run through QA checklist for this type
- Identify weak spots and flag them

Human reviews and provides feedback:
- Apply changes
- Note patterns for future improvement
- Update templates if relevant

## Revision Management

Track revisions:
```markdown
### Version History
- v1: Initial draft [date]
- v2: Applied client feedback [date] — changes: X, Y, Z
- v3: Final approved [date]
```

Revision limits:
- State revision rounds in proposal
- Track usage per project
- When limit reached, quote additional rounds

## Multi-Format Adaptation

When one piece of content needs multiple formats:

**Example: Article → Social**
- Article (full piece)
- LinkedIn post (key insight + CTA)
- Twitter thread (main points)
- Instagram carousel (visual summary)
- Email newsletter blurb

Adapt each for platform:
- Length constraints
- Tone differences
- Visual requirements

## Delivery Checklist

Before sending to client:
- [ ] All requirements from brief met
- [ ] Proofread / QA passed
- [ ] Correct formats and file types
- [ ] Clear file naming
- [ ] Cover email drafted
- [ ] Next steps mentioned

After delivery:
- [ ] Confirm client receipt
- [ ] Note delivery in project log
- [ ] Archive final files in client folder
- [ ] Update case study if notable
