# Client Communication

## Communication Principles

- Proactive > reactive — tell them before they ask
- Structured > stream of consciousness
- Written trail for important decisions
- Match their communication style (formal/casual)

## Weekly Status Template

```
Subject: [Project Name] - Week of [Date] Update

Hi [Name],

**Progress this week:**
- [Completed item 1]
- [Completed item 2]

**In progress:**
- [Item 1] — expected [date]

**Waiting on you:**
- [Item needing client input] — please by [date]

**Next week:**
- [Planned work]

[If issues:] **Heads up:** [issue and proposed solution]

Questions? Just reply.

[Signature]
```

## Handling Different Situations

### Client asks for status (ad-hoc)
- Check project board
- Summarize current phase, recent progress, next steps
- Flag any blockers or needs from them

### Client provides chaotic feedback
- Parse into structured list
- Categorize: bug fix / enhancement / scope change
- Respond with clarified list for confirmation

### Client requests scope change
- Acknowledge the request
- Assess impact (hours, timeline, cost)
- Propose options:
  - Add with additional budget
  - Swap for something of equal size
  - Defer to phase 2

### Client is slow to respond
- Day 3: gentle reminder
- Day 7: more urgent, explain impact on timeline
- Day 10: escalate to decision maker or pause

### Client is unhappy
- Acknowledge their frustration (don't defend)
- Clarify the specific issue
- Propose concrete resolution
- Draft response for human review before sending

## Response Templates

**Acknowledging feedback:**
> Thanks for the detailed feedback. To confirm I've captured everything correctly:
> 1. [item]
> 2. [item]
> Let me know if I missed anything before we proceed.

**Scope change response:**
> I can definitely look into [request]. Just to set expectations, this would be [additional scope/time/cost]. Want me to send a quick change order, or should we save it for phase 2?

**Deadline risk communication:**
> Wanted to give you a heads up: [issue] is putting our [date] deadline at risk. Here's what I recommend: [solution]. Let me know how you'd like to proceed.

**Invoice follow-up (gentle):**
> Just floating this to the top of your inbox — invoice [#] from [date] is still outstanding. Let me know if you need me to resend or if there are any questions.

## Meeting Preparation

Before client meetings:
- Review project status
- List discussion points
- Prepare visual updates if relevant
- Draft agenda to share in advance

After meetings:
- Summarize decisions and action items
- Send recap email within 24h
- Update project board
