# Agency Type Specifics

## Marketing Agency

**Key metrics to track:**
- Client MRR/revenue
- Campaign performance (ROAS, CPA, CTR)
- Content engagement
- Lead generation

**Typical deliverables:**
- Content calendars
- Social media posts
- Ad creatives and copy
- Performance reports
- Strategy documents

**Common scope creep:**
- "Can you just post this too?"
- Unlimited revision rounds on ads
- Channel expansion without budget increase

**Tools to integrate:**
- Meta Business Suite
- Google Ads/Analytics
- Social scheduling tools
- Email marketing platforms

---

## Development Agency

**Key metrics to track:**
- Sprint velocity
- Bug count and resolution time
- Deploy frequency
- Technical debt

**Typical deliverables:**
- Working software
- Technical documentation
- API specs
- Deployment guides

**Common scope creep:**
- "Just one more feature"
- Undefined "bug fixes" that are actually features
- Integration with systems not in original scope

**Tools to integrate:**
- GitHub/GitLab
- Project management (Linear, Jira)
- CI/CD systems
- Error monitoring

---

## Design Agency

**Key metrics to track:**
- Revision rounds used
- Time to first concept
- Client satisfaction
- Portfolio-worthy output

**Typical deliverables:**
- Brand identity
- UI/UX designs
- Marketing collateral
- Brand guidelines

**Common scope creep:**
- "Can you try a completely different direction?"
- Stakeholder additions mid-project
- Format additions (print added to digital scope)

**Tools to integrate:**
- Figma
- Asset management
- Feedback tools (Loom, Markup)

---

## Consulting Agency

**Key metrics to track:**
- Recommendations implemented
- Measurable client outcomes
- Repeat business rate
- Thought leadership output

**Typical deliverables:**
- Diagnostic reports
- Strategy documents
- Implementation roadmaps
- Executive presentations

**Common scope creep:**
- "Can you help us implement too?"
- Additional stakeholder interviews
- Expanded diagnostic scope

**Tools to integrate:**
- Knowledge base
- Data analysis tools
- Presentation tools

---

## Content Agency

**Key metrics to track:**
- Content volume produced
- SEO rankings achieved
- Engagement metrics
- Client retention

**Typical deliverables:**
- Blog posts and articles
- Social content
- Video scripts
- SEO reports

**Common scope creep:**
- Additional platforms
- Shorter review cycles
- "Can you also manage posting?"

**Tools to integrate:**
- SEO tools (Ahrefs, SEMrush)
- Content calendars
- Publishing platforms

---

## Automation Agency

**Key metrics to track:**
- Hours saved for client
- Automation reliability (uptime)
- ROI delivered
- Support tickets

**Typical deliverables:**
- Workflow implementations
- Integration setups
- Documentation
- Training materials

**Common scope creep:**
- "Can it also do X?"
- Legacy system integrations
- Ongoing support expectations

**Tools to integrate:**
- Automation platforms (Make, n8n, Zapier)
- API connections
- Monitoring systems
