# Workplace Safety & OSHA Compliance Skill

Turn your AI agent into a workplace safety officer. Generate hazard assessments, OSHA compliance audits, incident reports, safety programs, training matrices, and Job Hazard Analyses.

## Why This Exists

Workplace injuries cost US businesses $167 billion annually. Small and mid-size companies get hit hardest — they can't afford a full-time safety director, but they still face the same OSHA fines ($16,131 per serious violation, $161,323 for willful).

This skill gives any AI agent the frameworks to run professional-grade safety programs.

## What It Does

- **Safety Audits** — 29 CFR 1910/1926 compliance checks with gap analysis
- **Incident Reports** — Root cause analysis, corrective actions, OSHA 300 log guidance
- **Safety Programs** — LOTO, confined space, fall protection, HazCom, PPE, emergency action plans
- **Training Matrices** — Role-based requirements with regulatory basis and cost estimates
- **Job Hazard Analysis** — Step-by-step task breakdown with hierarchy of controls

## Industries Covered

Construction, manufacturing, warehouse/logistics, healthcare, food service, office/general industry.

## Get Started

Install the skill, then ask your agent:
- "Run a safety audit for our 50-person warehouse"
- "Generate a fall protection program"
- "Create a JHA for forklift loading operations"
- "Build a training matrix for our construction crew"

## More from AfrexAI

**AI Context Packs** — Pre-built agent configurations for specific industries. Manufacturing, healthcare, legal, construction, and more. Each pack drops straight into your agent and makes it an industry expert.

Browse packs: [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)

**Free Tools:**
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money to manual work
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Configure your first AI agent in minutes
