# Workforce Planning Framework

Build a data-driven workforce plan that aligns headcount, skills, and costs with business goals. Covers demand forecasting, gap analysis, succession planning, and contingent workforce strategy.

## When to Use
- Annual or quarterly headcount planning
- Post-merger workforce integration
- Scaling teams for new product lines
- Reducing labor costs without layoffs
- Building succession pipelines for critical roles

## How It Works

### 1. Current State Audit

Map every role against these dimensions:

| Dimension | What to Capture |
|-----------|----------------|
| Headcount | Filled vs open vs frozen positions by department |
| Skills inventory | Technical + soft skills rated 1-5 per employee |
| Tenure risk | Years in role, flight risk score (low/med/high) |
| Cost profile | Fully loaded cost (salary + benefits + overhead) |
| Utilization | Billable/productive hours ÷ available hours |

**Benchmark:** Fully loaded cost typically runs 1.25x-1.4x base salary (US), 1.3x-1.5x (UK/EU).

### 2. Demand Forecasting

Three methods — use all three and triangulate:

**Revenue-per-employee model:**
```
Required headcount = Target revenue ÷ Revenue per employee
```
- SaaS benchmark: $200K-$350K revenue per employee (2026)
- Professional services: $150K-$250K
- Manufacturing: $180K-$300K

**Driver-based model:**
```
Support staff needed = (Projected customers × tickets/customer/month) ÷ tickets/agent/month
Engineers needed = (Planned features × avg dev-weeks/feature) ÷ available dev-weeks/quarter
```

**Managerial span model:**
```
Managers needed = Total ICs ÷ Target span of control
```
- Engineering: 5-8 ICs per manager
- Sales: 6-10 reps per manager
- Support: 10-15 agents per manager

### 3. Gap Analysis

For each department, calculate:

| Metric | Formula |
|--------|---------|
| Headcount gap | Demand forecast - Current headcount - Pipeline hires |
| Skills gap | Required skill level - Current avg skill level (by competency) |
| Experience gap | Roles requiring 5+ years - Employees with 5+ years |
| Diversity gap | Target representation - Current representation |
| Budget gap | Required fully loaded cost - Approved budget |

**Priority scoring:**
```
Priority = (Business impact × 3) + (Time to fill × 2) + (Availability risk × 1)
```
Each factor scored 1-5. Anything scoring 20+ gets immediate action.

### 4. Supply Strategies

Match each gap to the right channel:

| Gap Type | Strategy | Timeline | Cost Index |
|----------|----------|----------|------------|
| Critical skill, long-term need | Full-time hire | 45-90 days | 1.0x |
| Critical skill, short-term need | Contract/freelance | 5-15 days | 1.5-2.0x |
| Emerging skill, current team | Upskilling/reskilling | 3-6 months | 0.2x |
| Leadership pipeline | Internal promotion + coaching | 6-12 months | 0.3x |
| Volume scaling | Outsource/offshore | 30-60 days | 0.4-0.6x |
| Repetitive tasks | AI agent automation | 2-8 weeks | 0.1x ongoing |

**2026 stat:** Companies using AI agents for workforce tasks report 30-40% reduction in administrative HR workload (TimeTrex, Feb 2026).

### 5. Succession Planning

For every critical role (role where vacancy causes >$50K/month revenue impact):

- **Identify 2-3 internal successors** rated on readiness (ready now / 6 months / 12+ months)
- **Build development plans** with specific skill gaps and training
- **Set emergency coverage** — who steps in tomorrow if this person leaves?
- **Track flight risk** quarterly — compensation competitiveness, engagement scores, tenure patterns

**Key number:** Replacing a senior employee costs 100-200% of annual salary. Succession planning cuts this by 50-70%.

### 6. Contingent Workforce Strategy

Map your workforce mix target:

| Category | Typical % | Best For |
|----------|-----------|----------|
| Full-time employees | 70-80% | Core competencies, IP, culture |
| Contractors/freelancers | 10-15% | Specialized skills, surge capacity |
| Outsourced teams | 5-10% | Non-core operations, scale |
| AI agents | 5-15% | Data processing, scheduling, reporting |

**Compliance flags:**
- IRS 20-factor test (US) — misclassification penalties up to $50/filing
- IR35 (UK) — inside/outside determination required before engagement
- EU Working Time Directive — applies to some contractor arrangements

### 7. Annual Workforce Plan Template

```
WORKFORCE PLAN — [COMPANY] — [YEAR]

Executive Summary:
- Current headcount: [X]
- Planned end-of-year headcount: [Y]
- Net change: [+/- Z]
- Total labor budget: $[amount]
- Key risks: [top 3]

Department Plans:
[For each department]
- Current: [X] FTEs, [Y] contractors
- Planned: [X'] FTEs, [Y'] contractors
- Key hires: [role, level, Q target]
- Skills to develop: [skill, # employees, program]
- Automation opportunities: [task, estimated savings]
- Budget: $[amount] (+/-% vs current)

Succession Pipeline:
- Critical roles at risk: [count]
- Roles with ready-now successor: [count] ([%])
- Development investments needed: $[amount]

Contingent Workforce:
- Current mix: [X]% FTE / [Y]% contractor / [Z]% outsourced
- Target mix: [X']% / [Y']% / [Z']%
- Estimated savings from mix optimization: $[amount]
```

### 8. Quarterly Review Cadence

| Quarter | Focus |
|---------|-------|
| Q1 | Full plan build, budget approval, hiring roadmap |
| Q2 | Mid-year check — actual vs plan, adjust for business changes |
| Q3 | Succession review, performance calibration, retention risk |
| Q4 | Next-year demand forecast, budget submission, strategic shifts |

**Each review should answer:**
1. Are we on track with hiring plan? (within 10% = green)
2. Any critical roles unfilled >60 days?
3. Has business direction changed enough to reforecast?
4. Are we spending within 5% of labor budget?
5. Any retention risks that need immediate action?

## Resources

- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where AI agents can reduce workforce costs
- [AI Agent Context Packs](https://afrexai-cto.github.io/context-packs/) — Industry-specific frameworks ($47/pack)
  - Recruitment Pack: hiring pipelines, candidate scoring, interview frameworks
  - Professional Services Pack: utilization tracking, capacity planning, resource allocation
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Deploy workforce automation in minutes
- **Bundles:** Pick 3 for $97 | All 10 for $197 | Everything Bundle $247
